/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.BankAccount;
import org.wisepersist.pinpayments.pojo.Recipient;
import org.wisepersist.pinpayments.pojo.RecipientBase;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableRecipient
implements Recipient {
    @Nullable
    private final BankAccount bankAccount;
    @Nullable
    private final String bankAccountToken;
    private final String email;
    @Nullable
    private final String name;

    private ImmutableRecipient(@Nullable BankAccount bankAccount, @Nullable String bankAccountToken, String email, @Nullable String name) {
        this.bankAccount = bankAccount;
        this.bankAccountToken = bankAccountToken;
        this.email = email;
        this.name = name;
    }

    @Override
    @Nullable
    public BankAccount bankAccount() {
        return this.bankAccount;
    }

    @Override
    @Nullable
    public String bankAccountToken() {
        return this.bankAccountToken;
    }

    @Override
    public String email() {
        return this.email;
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    public final ImmutableRecipient withBankAccount(@Nullable BankAccount value) {
        if (this.bankAccount == value) {
            return this;
        }
        return new ImmutableRecipient(value, this.bankAccountToken, this.email, this.name);
    }

    public final ImmutableRecipient withBankAccountToken(@Nullable String value) {
        if (Objects.equal((Object)this.bankAccountToken, (Object)value)) {
            return this;
        }
        return new ImmutableRecipient(this.bankAccount, value, this.email, this.name);
    }

    public final ImmutableRecipient withEmail(String value) {
        if (this.email.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"email");
        return new ImmutableRecipient(this.bankAccount, this.bankAccountToken, newValue, this.name);
    }

    public final ImmutableRecipient withName(@Nullable String value) {
        if (Objects.equal((Object)this.name, (Object)value)) {
            return this;
        }
        return new ImmutableRecipient(this.bankAccount, this.bankAccountToken, this.email, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecipient && this.equalTo((ImmutableRecipient)another);
    }

    private boolean equalTo(ImmutableRecipient another) {
        return Objects.equal((Object)this.bankAccount, (Object)another.bankAccount) && Objects.equal((Object)this.bankAccountToken, (Object)another.bankAccountToken) && this.email.equals(another.email) && Objects.equal((Object)this.name, (Object)another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.bankAccount});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.bankAccountToken});
        h += (h << 5) + this.email.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.name});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Recipient").omitNullValues().add("bankAccount", (Object)this.bankAccount).add("bankAccountToken", (Object)this.bankAccountToken).add("email", (Object)this.email).add("name", (Object)this.name).toString();
    }

    public static ImmutableRecipient copyOf(Recipient instance) {
        if (instance instanceof ImmutableRecipient) {
            return (ImmutableRecipient)instance;
        }
        return ImmutableRecipient.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EMAIL = 1L;
        private long initBits = 1L;
        @Nullable
        private BankAccount bankAccount;
        @Nullable
        private String bankAccountToken;
        @Nullable
        private String email;
        @Nullable
        private String name;

        private Builder() {
        }

        public final Builder from(Recipient instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecipientBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RecipientBase instance;
            if (object instanceof Recipient) {
                String bankAccountTokenValue;
                instance = (Recipient)object;
                BankAccount bankAccountValue = instance.bankAccount();
                if (bankAccountValue != null) {
                    this.bankAccount(bankAccountValue);
                }
                if ((bankAccountTokenValue = instance.bankAccountToken()) != null) {
                    this.bankAccountToken(bankAccountTokenValue);
                }
            }
            if (object instanceof RecipientBase) {
                instance = (RecipientBase)object;
                String nameValue = instance.name();
                if (nameValue != null) {
                    this.name(nameValue);
                }
                this.email(instance.email());
            }
        }

        public final Builder bankAccount(@Nullable BankAccount bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public final Builder bankAccountToken(@Nullable String bankAccountToken) {
            this.bankAccountToken = bankAccountToken;
            return this;
        }

        public final Builder email(String email) {
            this.email = (String)Preconditions.checkNotNull((Object)email, (Object)"email");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public ImmutableRecipient build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRecipient(this.bankAccount, this.bankAccountToken, this.email, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("email");
            }
            return "Cannot build Recipient, some of required attributes are not set " + attributes;
        }
    }
}

