/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.ErrorResponse;
import org.wisepersist.pinpayments.pojo.RefundResponse;
import org.wisepersist.pinpayments.pojo.RefundResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableRefundResponse
implements RefundResponse {
    @Nullable
    private final RefundResult response;
    @Nullable
    private final ErrorResponse errorResponse;

    private ImmutableRefundResponse(@Nullable RefundResult response, @Nullable ErrorResponse errorResponse) {
        this.response = response;
        this.errorResponse = errorResponse;
    }

    @Override
    @Nullable
    public RefundResult response() {
        return this.response;
    }

    @Override
    @Nullable
    public ErrorResponse errorResponse() {
        return this.errorResponse;
    }

    public final ImmutableRefundResponse withResponse(@Nullable RefundResult value) {
        if (this.response == value) {
            return this;
        }
        return new ImmutableRefundResponse(value, this.errorResponse);
    }

    public final ImmutableRefundResponse withErrorResponse(@Nullable ErrorResponse value) {
        if (this.errorResponse == value) {
            return this;
        }
        return new ImmutableRefundResponse(this.response, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRefundResponse && this.equalTo((ImmutableRefundResponse)another);
    }

    private boolean equalTo(ImmutableRefundResponse another) {
        return Objects.equal((Object)this.response, (Object)another.response) && Objects.equal((Object)this.errorResponse, (Object)another.errorResponse);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.response});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.errorResponse});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RefundResponse").omitNullValues().add("response", (Object)this.response).add("errorResponse", (Object)this.errorResponse).toString();
    }

    public static ImmutableRefundResponse copyOf(RefundResponse instance) {
        if (instance instanceof ImmutableRefundResponse) {
            return (ImmutableRefundResponse)instance;
        }
        return ImmutableRefundResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private RefundResult response;
        @Nullable
        private ErrorResponse errorResponse;

        private Builder() {
        }

        public final Builder from(RefundResponse instance) {
            ErrorResponse errorResponseValue;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            RefundResult responseValue = instance.response();
            if (responseValue != null) {
                this.response(responseValue);
            }
            if ((errorResponseValue = instance.errorResponse()) != null) {
                this.errorResponse(errorResponseValue);
            }
            return this;
        }

        public final Builder response(@Nullable RefundResult response) {
            this.response = response;
            return this;
        }

        public final Builder errorResponse(@Nullable ErrorResponse errorResponse) {
            this.errorResponse = errorResponse;
            return this;
        }

        public ImmutableRefundResponse build() {
            return new ImmutableRefundResponse(this.response, this.errorResponse);
        }
    }
}

