/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.Transfer;
import org.wisepersist.pinpayments.pojo.TransferBase;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableTransfer
implements Transfer {
    private final String description;
    private final Integer amount;
    private final String currency;
    private final String recipient;

    private ImmutableTransfer(String description, Integer amount, String currency, String recipient) {
        this.description = description;
        this.amount = amount;
        this.currency = currency;
        this.recipient = recipient;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Integer amount() {
        return this.amount;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public String recipient() {
        return this.recipient;
    }

    public final ImmutableTransfer withDescription(String value) {
        if (this.description.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"description");
        return new ImmutableTransfer(newValue, this.amount, this.currency, this.recipient);
    }

    public final ImmutableTransfer withAmount(Integer value) {
        if (this.amount.equals(value)) {
            return this;
        }
        Integer newValue = (Integer)Preconditions.checkNotNull((Object)value, (Object)"amount");
        return new ImmutableTransfer(this.description, newValue, this.currency, this.recipient);
    }

    public final ImmutableTransfer withCurrency(String value) {
        if (this.currency.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"currency");
        return new ImmutableTransfer(this.description, this.amount, newValue, this.recipient);
    }

    public final ImmutableTransfer withRecipient(String value) {
        if (this.recipient.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"recipient");
        return new ImmutableTransfer(this.description, this.amount, this.currency, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransfer && this.equalTo((ImmutableTransfer)another);
    }

    private boolean equalTo(ImmutableTransfer another) {
        return this.description.equals(another.description) && this.amount.equals(another.amount) && this.currency.equals(another.currency) && this.recipient.equals(another.recipient);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + this.recipient.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Transfer").omitNullValues().add("description", (Object)this.description).add("amount", (Object)this.amount).add("currency", (Object)this.currency).add("recipient", (Object)this.recipient).toString();
    }

    public static ImmutableTransfer copyOf(Transfer instance) {
        if (instance instanceof ImmutableTransfer) {
            return (ImmutableTransfer)instance;
        }
        return ImmutableTransfer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DESCRIPTION = 1L;
        private static final long INIT_BIT_AMOUNT = 2L;
        private static final long INIT_BIT_CURRENCY = 4L;
        private static final long INIT_BIT_RECIPIENT = 8L;
        private long initBits = 15L;
        @Nullable
        private String description;
        @Nullable
        private Integer amount;
        @Nullable
        private String currency;
        @Nullable
        private String recipient;

        private Builder() {
        }

        public final Builder from(TransferBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Transfer instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof TransferBase) {
                TransferBase instance = (TransferBase)object;
                this.recipient(instance.recipient());
                this.description(instance.description());
                this.amount(instance.amount());
                this.currency(instance.currency());
            }
        }

        public final Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder amount(Integer amount) {
            this.amount = (Integer)Preconditions.checkNotNull((Object)amount, (Object)"amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = (String)Preconditions.checkNotNull((Object)currency, (Object)"currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder recipient(String recipient) {
            this.recipient = (String)Preconditions.checkNotNull((Object)recipient, (Object)"recipient");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableTransfer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransfer(this.description, this.amount, this.currency, this.recipient);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("recipient");
            }
            return "Cannot build Transfer, some of required attributes are not set " + attributes;
        }
    }
}

