/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.TransferLineItemBase;
import org.wisepersist.pinpayments.pojo.TransferLineItemResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableTransferLineItemResult
implements TransferLineItemResult {
    @Nullable
    private final String token;
    private final String createdAt;
    private final String type;
    @Nullable
    private final String object;
    private final Integer amount;

    private ImmutableTransferLineItemResult(@Nullable String token, String createdAt, String type, @Nullable String object, Integer amount) {
        this.token = token;
        this.createdAt = createdAt;
        this.type = type;
        this.object = object;
        this.amount = amount;
    }

    @Override
    @Nullable
    public String token() {
        return this.token;
    }

    @Override
    public String createdAt() {
        return this.createdAt;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public String object() {
        return this.object;
    }

    @Override
    public Integer amount() {
        return this.amount;
    }

    public final ImmutableTransferLineItemResult withToken(@Nullable String value) {
        if (Objects.equal((Object)this.token, (Object)value)) {
            return this;
        }
        return new ImmutableTransferLineItemResult(value, this.createdAt, this.type, this.object, this.amount);
    }

    public final ImmutableTransferLineItemResult withCreatedAt(String value) {
        if (this.createdAt.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableTransferLineItemResult(this.token, newValue, this.type, this.object, this.amount);
    }

    public final ImmutableTransferLineItemResult withType(String value) {
        if (this.type.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"type");
        return new ImmutableTransferLineItemResult(this.token, this.createdAt, newValue, this.object, this.amount);
    }

    public final ImmutableTransferLineItemResult withObject(@Nullable String value) {
        if (Objects.equal((Object)this.object, (Object)value)) {
            return this;
        }
        return new ImmutableTransferLineItemResult(this.token, this.createdAt, this.type, value, this.amount);
    }

    public final ImmutableTransferLineItemResult withAmount(Integer value) {
        if (this.amount.equals(value)) {
            return this;
        }
        Integer newValue = (Integer)Preconditions.checkNotNull((Object)value, (Object)"amount");
        return new ImmutableTransferLineItemResult(this.token, this.createdAt, this.type, this.object, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransferLineItemResult && this.equalTo((ImmutableTransferLineItemResult)another);
    }

    private boolean equalTo(ImmutableTransferLineItemResult another) {
        return Objects.equal((Object)this.token, (Object)another.token) && this.createdAt.equals(another.createdAt) && this.type.equals(another.type) && Objects.equal((Object)this.object, (Object)another.object) && this.amount.equals(another.amount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.token});
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.object});
        h += (h << 5) + this.amount.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransferLineItemResult").omitNullValues().add("token", (Object)this.token).add("createdAt", (Object)this.createdAt).add("type", (Object)this.type).add("object", (Object)this.object).add("amount", (Object)this.amount).toString();
    }

    public static ImmutableTransferLineItemResult copyOf(TransferLineItemResult instance) {
        if (instance instanceof ImmutableTransferLineItemResult) {
            return (ImmutableTransferLineItemResult)instance;
        }
        return ImmutableTransferLineItemResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_AMOUNT = 4L;
        private long initBits = 7L;
        @Nullable
        private String token;
        @Nullable
        private String createdAt;
        @Nullable
        private String type;
        @Nullable
        private String object;
        @Nullable
        private Integer amount;

        private Builder() {
        }

        public final Builder from(TransferLineItemResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TransferLineItemBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TransferLineItemBase instance;
            if (object instanceof TransferLineItemResult) {
                instance = (TransferLineItemResult)object;
                this.createdAt(instance.createdAt());
                String tokenValue = instance.token();
                if (tokenValue != null) {
                    this.token(tokenValue);
                }
            }
            if (object instanceof TransferLineItemBase) {
                instance = (TransferLineItemBase)object;
                this.type(instance.type());
                this.amount(instance.amount());
                String objectValue = instance.object();
                if (objectValue != null) {
                    this.object(objectValue);
                }
            }
        }

        public final Builder token(@Nullable String token) {
            this.token = token;
            return this;
        }

        public final Builder createdAt(String createdAt) {
            this.createdAt = (String)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder object(@Nullable String object) {
            this.object = object;
            return this;
        }

        public final Builder amount(Integer amount) {
            this.amount = (Integer)Preconditions.checkNotNull((Object)amount, (Object)"amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTransferLineItemResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransferLineItemResult(this.token, this.createdAt, this.type, this.object, this.amount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("amount");
            }
            return "Cannot build TransferLineItemResult, some of required attributes are not set " + attributes;
        }
    }
}

