/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.BankAccountResult;
import org.wisepersist.pinpayments.pojo.TransferBase;
import org.wisepersist.pinpayments.pojo.TransferResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableTransferResult
implements TransferResult {
    private final String token;
    private final String status;
    private final Integer totalDebits;
    private final Integer totalCredits;
    private final String createdAt;
    private final String paidAt;
    private final BankAccountResult bankAccount;
    private final String description;
    private final Integer amount;
    private final String currency;
    private final String recipient;

    private ImmutableTransferResult(String token, String status, Integer totalDebits, Integer totalCredits, String createdAt, String paidAt, BankAccountResult bankAccount, String description, Integer amount, String currency, String recipient) {
        this.token = token;
        this.status = status;
        this.totalDebits = totalDebits;
        this.totalCredits = totalCredits;
        this.createdAt = createdAt;
        this.paidAt = paidAt;
        this.bankAccount = bankAccount;
        this.description = description;
        this.amount = amount;
        this.currency = currency;
        this.recipient = recipient;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public String status() {
        return this.status;
    }

    @Override
    public Integer totalDebits() {
        return this.totalDebits;
    }

    @Override
    public Integer totalCredits() {
        return this.totalCredits;
    }

    @Override
    public String createdAt() {
        return this.createdAt;
    }

    @Override
    public String paidAt() {
        return this.paidAt;
    }

    @Override
    public BankAccountResult bankAccount() {
        return this.bankAccount;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Integer amount() {
        return this.amount;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public String recipient() {
        return this.recipient;
    }

    public final ImmutableTransferResult withToken(String value) {
        if (this.token.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
        return new ImmutableTransferResult(newValue, this.status, this.totalDebits, this.totalCredits, this.createdAt, this.paidAt, this.bankAccount, this.description, this.amount, this.currency, this.recipient);
    }

    public final ImmutableTransferResult withStatus(String value) {
        if (this.status.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"status");
        return new ImmutableTransferResult(this.token, newValue, this.totalDebits, this.totalCredits, this.createdAt, this.paidAt, this.bankAccount, this.description, this.amount, this.currency, this.recipient);
    }

    public final ImmutableTransferResult withTotalDebits(Integer value) {
        if (this.totalDebits.equals(value)) {
            return this;
        }
        Integer newValue = (Integer)Preconditions.checkNotNull((Object)value, (Object)"totalDebits");
        return new ImmutableTransferResult(this.token, this.status, newValue, this.totalCredits, this.createdAt, this.paidAt, this.bankAccount, this.description, this.amount, this.currency, this.recipient);
    }

    public final ImmutableTransferResult withTotalCredits(Integer value) {
        if (this.totalCredits.equals(value)) {
            return this;
        }
        Integer newValue = (Integer)Preconditions.checkNotNull((Object)value, (Object)"totalCredits");
        return new ImmutableTransferResult(this.token, this.status, this.totalDebits, newValue, this.createdAt, this.paidAt, this.bankAccount, this.description, this.amount, this.currency, this.recipient);
    }

    public final ImmutableTransferResult withCreatedAt(String value) {
        if (this.createdAt.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableTransferResult(this.token, this.status, this.totalDebits, this.totalCredits, newValue, this.paidAt, this.bankAccount, this.description, this.amount, this.currency, this.recipient);
    }

    public final ImmutableTransferResult withPaidAt(String value) {
        if (this.paidAt.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"paidAt");
        return new ImmutableTransferResult(this.token, this.status, this.totalDebits, this.totalCredits, this.createdAt, newValue, this.bankAccount, this.description, this.amount, this.currency, this.recipient);
    }

    public final ImmutableTransferResult withBankAccount(BankAccountResult value) {
        if (this.bankAccount == value) {
            return this;
        }
        BankAccountResult newValue = (BankAccountResult)Preconditions.checkNotNull((Object)value, (Object)"bankAccount");
        return new ImmutableTransferResult(this.token, this.status, this.totalDebits, this.totalCredits, this.createdAt, this.paidAt, newValue, this.description, this.amount, this.currency, this.recipient);
    }

    public final ImmutableTransferResult withDescription(String value) {
        if (this.description.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"description");
        return new ImmutableTransferResult(this.token, this.status, this.totalDebits, this.totalCredits, this.createdAt, this.paidAt, this.bankAccount, newValue, this.amount, this.currency, this.recipient);
    }

    public final ImmutableTransferResult withAmount(Integer value) {
        if (this.amount.equals(value)) {
            return this;
        }
        Integer newValue = (Integer)Preconditions.checkNotNull((Object)value, (Object)"amount");
        return new ImmutableTransferResult(this.token, this.status, this.totalDebits, this.totalCredits, this.createdAt, this.paidAt, this.bankAccount, this.description, newValue, this.currency, this.recipient);
    }

    public final ImmutableTransferResult withCurrency(String value) {
        if (this.currency.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"currency");
        return new ImmutableTransferResult(this.token, this.status, this.totalDebits, this.totalCredits, this.createdAt, this.paidAt, this.bankAccount, this.description, this.amount, newValue, this.recipient);
    }

    public final ImmutableTransferResult withRecipient(String value) {
        if (this.recipient.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"recipient");
        return new ImmutableTransferResult(this.token, this.status, this.totalDebits, this.totalCredits, this.createdAt, this.paidAt, this.bankAccount, this.description, this.amount, this.currency, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransferResult && this.equalTo((ImmutableTransferResult)another);
    }

    private boolean equalTo(ImmutableTransferResult another) {
        return this.token.equals(another.token) && this.status.equals(another.status) && this.totalDebits.equals(another.totalDebits) && this.totalCredits.equals(another.totalCredits) && this.createdAt.equals(another.createdAt) && this.paidAt.equals(another.paidAt) && this.bankAccount.equals(another.bankAccount) && this.description.equals(another.description) && this.amount.equals(another.amount) && this.currency.equals(another.currency) && this.recipient.equals(another.recipient);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.totalDebits.hashCode();
        h += (h << 5) + this.totalCredits.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.paidAt.hashCode();
        h += (h << 5) + this.bankAccount.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + this.recipient.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransferResult").omitNullValues().add("token", (Object)this.token).add("status", (Object)this.status).add("totalDebits", (Object)this.totalDebits).add("totalCredits", (Object)this.totalCredits).add("createdAt", (Object)this.createdAt).add("paidAt", (Object)this.paidAt).add("bankAccount", (Object)this.bankAccount).add("description", (Object)this.description).add("amount", (Object)this.amount).add("currency", (Object)this.currency).add("recipient", (Object)this.recipient).toString();
    }

    public static ImmutableTransferResult copyOf(TransferResult instance) {
        if (instance instanceof ImmutableTransferResult) {
            return (ImmutableTransferResult)instance;
        }
        return ImmutableTransferResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_STATUS = 2L;
        private static final long INIT_BIT_TOTAL_DEBITS = 4L;
        private static final long INIT_BIT_TOTAL_CREDITS = 8L;
        private static final long INIT_BIT_CREATED_AT = 16L;
        private static final long INIT_BIT_PAID_AT = 32L;
        private static final long INIT_BIT_BANK_ACCOUNT = 64L;
        private static final long INIT_BIT_DESCRIPTION = 128L;
        private static final long INIT_BIT_AMOUNT = 256L;
        private static final long INIT_BIT_CURRENCY = 512L;
        private static final long INIT_BIT_RECIPIENT = 1024L;
        private long initBits = 2047L;
        @Nullable
        private String token;
        @Nullable
        private String status;
        @Nullable
        private Integer totalDebits;
        @Nullable
        private Integer totalCredits;
        @Nullable
        private String createdAt;
        @Nullable
        private String paidAt;
        @Nullable
        private BankAccountResult bankAccount;
        @Nullable
        private String description;
        @Nullable
        private Integer amount;
        @Nullable
        private String currency;
        @Nullable
        private String recipient;

        private Builder() {
        }

        public final Builder from(TransferBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TransferResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TransferBase instance;
            if (object instanceof TransferBase) {
                instance = (TransferBase)object;
                this.recipient(instance.recipient());
                this.description(instance.description());
                this.amount(instance.amount());
                this.currency(instance.currency());
            }
            if (object instanceof TransferResult) {
                instance = (TransferResult)object;
                this.bankAccount(instance.bankAccount());
                this.createdAt(instance.createdAt());
                this.totalCredits(instance.totalCredits());
                this.paidAt(instance.paidAt());
                this.totalDebits(instance.totalDebits());
                this.token(instance.token());
                this.status(instance.status());
            }
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder status(String status) {
            this.status = (String)Preconditions.checkNotNull((Object)status, (Object)"status");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder totalDebits(Integer totalDebits) {
            this.totalDebits = (Integer)Preconditions.checkNotNull((Object)totalDebits, (Object)"totalDebits");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder totalCredits(Integer totalCredits) {
            this.totalCredits = (Integer)Preconditions.checkNotNull((Object)totalCredits, (Object)"totalCredits");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder createdAt(String createdAt) {
            this.createdAt = (String)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder paidAt(String paidAt) {
            this.paidAt = (String)Preconditions.checkNotNull((Object)paidAt, (Object)"paidAt");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder bankAccount(BankAccountResult bankAccount) {
            this.bankAccount = (BankAccountResult)Preconditions.checkNotNull((Object)bankAccount, (Object)"bankAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder amount(Integer amount) {
            this.amount = (Integer)Preconditions.checkNotNull((Object)amount, (Object)"amount");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = (String)Preconditions.checkNotNull((Object)currency, (Object)"currency");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder recipient(String recipient) {
            this.recipient = (String)Preconditions.checkNotNull((Object)recipient, (Object)"recipient");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public ImmutableTransferResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransferResult(this.token, this.status, this.totalDebits, this.totalCredits, this.createdAt, this.paidAt, this.bankAccount, this.description, this.amount, this.currency, this.recipient);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("totalDebits");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("totalCredits");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("paidAt");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("bankAccount");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("recipient");
            }
            return "Cannot build TransferResult, some of required attributes are not set " + attributes;
        }
    }
}

