/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.WebhookEndpointResponse;
import org.wisepersist.pinpayments.pojo.WebhookEndpointResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableWebhookEndpointResponse
implements WebhookEndpointResponse {
    private final WebhookEndpointResult response;

    private ImmutableWebhookEndpointResponse(WebhookEndpointResult response) {
        this.response = response;
    }

    @Override
    public WebhookEndpointResult response() {
        return this.response;
    }

    public final ImmutableWebhookEndpointResponse withResponse(WebhookEndpointResult value) {
        if (this.response == value) {
            return this;
        }
        WebhookEndpointResult newValue = (WebhookEndpointResult)Preconditions.checkNotNull((Object)value, (Object)"response");
        return new ImmutableWebhookEndpointResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookEndpointResponse && this.equalTo((ImmutableWebhookEndpointResponse)another);
    }

    private boolean equalTo(ImmutableWebhookEndpointResponse another) {
        return this.response.equals(another.response);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.response.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WebhookEndpointResponse").omitNullValues().add("response", (Object)this.response).toString();
    }

    public static ImmutableWebhookEndpointResponse copyOf(WebhookEndpointResponse instance) {
        if (instance instanceof ImmutableWebhookEndpointResponse) {
            return (ImmutableWebhookEndpointResponse)instance;
        }
        return ImmutableWebhookEndpointResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE = 1L;
        private long initBits = 1L;
        @Nullable
        private WebhookEndpointResult response;

        private Builder() {
        }

        public final Builder from(WebhookEndpointResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.response(instance.response());
            return this;
        }

        public final Builder response(WebhookEndpointResult response) {
            this.response = (WebhookEndpointResult)Preconditions.checkNotNull((Object)response, (Object)"response");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableWebhookEndpointResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebhookEndpointResponse(this.response);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("response");
            }
            return "Cannot build WebhookEndpointResponse, some of required attributes are not set " + attributes;
        }
    }
}

