/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.WebhookEndpointResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableWebhookEndpointResult
implements WebhookEndpointResult {
    private final String token;
    private final String url;
    private final String key;
    private final String createdAt;
    private final String updatedAt;

    private ImmutableWebhookEndpointResult(String token, String url, String key, String createdAt, String updatedAt) {
        this.token = token;
        this.url = url;
        this.key = key;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String createdAt() {
        return this.createdAt;
    }

    @Override
    public String updatedAt() {
        return this.updatedAt;
    }

    public final ImmutableWebhookEndpointResult withToken(String value) {
        if (this.token.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
        return new ImmutableWebhookEndpointResult(newValue, this.url, this.key, this.createdAt, this.updatedAt);
    }

    public final ImmutableWebhookEndpointResult withUrl(String value) {
        if (this.url.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"url");
        return new ImmutableWebhookEndpointResult(this.token, newValue, this.key, this.createdAt, this.updatedAt);
    }

    public final ImmutableWebhookEndpointResult withKey(String value) {
        if (this.key.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"key");
        return new ImmutableWebhookEndpointResult(this.token, this.url, newValue, this.createdAt, this.updatedAt);
    }

    public final ImmutableWebhookEndpointResult withCreatedAt(String value) {
        if (this.createdAt.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableWebhookEndpointResult(this.token, this.url, this.key, newValue, this.updatedAt);
    }

    public final ImmutableWebhookEndpointResult withUpdatedAt(String value) {
        if (this.updatedAt.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"updatedAt");
        return new ImmutableWebhookEndpointResult(this.token, this.url, this.key, this.createdAt, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookEndpointResult && this.equalTo((ImmutableWebhookEndpointResult)another);
    }

    private boolean equalTo(ImmutableWebhookEndpointResult another) {
        return this.token.equals(another.token) && this.url.equals(another.url) && this.key.equals(another.key) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WebhookEndpointResult").omitNullValues().add("token", (Object)this.token).add("url", (Object)this.url).add("key", (Object)this.key).add("createdAt", (Object)this.createdAt).add("updatedAt", (Object)this.updatedAt).toString();
    }

    public static ImmutableWebhookEndpointResult copyOf(WebhookEndpointResult instance) {
        if (instance instanceof ImmutableWebhookEndpointResult) {
            return (ImmutableWebhookEndpointResult)instance;
        }
        return ImmutableWebhookEndpointResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_URL = 2L;
        private static final long INIT_BIT_KEY = 4L;
        private static final long INIT_BIT_CREATED_AT = 8L;
        private static final long INIT_BIT_UPDATED_AT = 16L;
        private long initBits = 31L;
        @Nullable
        private String token;
        @Nullable
        private String url;
        @Nullable
        private String key;
        @Nullable
        private String createdAt;
        @Nullable
        private String updatedAt;

        private Builder() {
        }

        public final Builder from(WebhookEndpointResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.token(instance.token());
            this.url(instance.url());
            this.key(instance.key());
            this.createdAt(instance.createdAt());
            this.updatedAt(instance.updatedAt());
            return this;
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder url(String url) {
            this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder key(String key) {
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder createdAt(String createdAt) {
            this.createdAt = (String)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = (String)Preconditions.checkNotNull((Object)updatedAt, (Object)"updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableWebhookEndpointResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebhookEndpointResult(this.token, this.url, this.key, this.createdAt, this.updatedAt);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("updatedAt");
            }
            return "Cannot build WebhookEndpointResult, some of required attributes are not set " + attributes;
        }
    }
}

