/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.WebhookResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableWebhookResult
implements WebhookResult {
    private final String token;
    private final String status;
    private final String url;
    private final String eventToken;
    private final String createdAt;
    private final String acceptedAt;
    @Nullable
    private final String nextRun;
    private final Integer retries;
    private final HashMap<String, Object> errors;

    private ImmutableWebhookResult(String token, String status, String url, String eventToken, String createdAt, String acceptedAt, @Nullable String nextRun, Integer retries, HashMap<String, Object> errors) {
        this.token = token;
        this.status = status;
        this.url = url;
        this.eventToken = eventToken;
        this.createdAt = createdAt;
        this.acceptedAt = acceptedAt;
        this.nextRun = nextRun;
        this.retries = retries;
        this.errors = errors;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public String status() {
        return this.status;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String eventToken() {
        return this.eventToken;
    }

    @Override
    public String createdAt() {
        return this.createdAt;
    }

    @Override
    public String acceptedAt() {
        return this.acceptedAt;
    }

    @Override
    @Nullable
    public String nextRun() {
        return this.nextRun;
    }

    @Override
    public Integer retries() {
        return this.retries;
    }

    @Override
    public HashMap<String, Object> errors() {
        return this.errors;
    }

    public final ImmutableWebhookResult withToken(String value) {
        if (this.token.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
        return new ImmutableWebhookResult(newValue, this.status, this.url, this.eventToken, this.createdAt, this.acceptedAt, this.nextRun, this.retries, this.errors);
    }

    public final ImmutableWebhookResult withStatus(String value) {
        if (this.status.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"status");
        return new ImmutableWebhookResult(this.token, newValue, this.url, this.eventToken, this.createdAt, this.acceptedAt, this.nextRun, this.retries, this.errors);
    }

    public final ImmutableWebhookResult withUrl(String value) {
        if (this.url.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"url");
        return new ImmutableWebhookResult(this.token, this.status, newValue, this.eventToken, this.createdAt, this.acceptedAt, this.nextRun, this.retries, this.errors);
    }

    public final ImmutableWebhookResult withEventToken(String value) {
        if (this.eventToken.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"eventToken");
        return new ImmutableWebhookResult(this.token, this.status, this.url, newValue, this.createdAt, this.acceptedAt, this.nextRun, this.retries, this.errors);
    }

    public final ImmutableWebhookResult withCreatedAt(String value) {
        if (this.createdAt.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableWebhookResult(this.token, this.status, this.url, this.eventToken, newValue, this.acceptedAt, this.nextRun, this.retries, this.errors);
    }

    public final ImmutableWebhookResult withAcceptedAt(String value) {
        if (this.acceptedAt.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"acceptedAt");
        return new ImmutableWebhookResult(this.token, this.status, this.url, this.eventToken, this.createdAt, newValue, this.nextRun, this.retries, this.errors);
    }

    public final ImmutableWebhookResult withNextRun(@Nullable String value) {
        if (Objects.equal((Object)this.nextRun, (Object)value)) {
            return this;
        }
        return new ImmutableWebhookResult(this.token, this.status, this.url, this.eventToken, this.createdAt, this.acceptedAt, value, this.retries, this.errors);
    }

    public final ImmutableWebhookResult withRetries(Integer value) {
        if (this.retries.equals(value)) {
            return this;
        }
        Integer newValue = (Integer)Preconditions.checkNotNull((Object)value, (Object)"retries");
        return new ImmutableWebhookResult(this.token, this.status, this.url, this.eventToken, this.createdAt, this.acceptedAt, this.nextRun, newValue, this.errors);
    }

    public final ImmutableWebhookResult withErrors(HashMap<String, Object> value) {
        if (this.errors == value) {
            return this;
        }
        HashMap newValue = (HashMap)Preconditions.checkNotNull(value, (Object)"errors");
        return new ImmutableWebhookResult(this.token, this.status, this.url, this.eventToken, this.createdAt, this.acceptedAt, this.nextRun, this.retries, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookResult && this.equalTo((ImmutableWebhookResult)another);
    }

    private boolean equalTo(ImmutableWebhookResult another) {
        return this.token.equals(another.token) && this.status.equals(another.status) && this.url.equals(another.url) && this.eventToken.equals(another.eventToken) && this.createdAt.equals(another.createdAt) && this.acceptedAt.equals(another.acceptedAt) && Objects.equal((Object)this.nextRun, (Object)another.nextRun) && this.retries.equals(another.retries) && this.errors.equals(another.errors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.eventToken.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.acceptedAt.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.nextRun});
        h += (h << 5) + this.retries.hashCode();
        h += (h << 5) + this.errors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WebhookResult").omitNullValues().add("token", (Object)this.token).add("status", (Object)this.status).add("url", (Object)this.url).add("eventToken", (Object)this.eventToken).add("createdAt", (Object)this.createdAt).add("acceptedAt", (Object)this.acceptedAt).add("nextRun", (Object)this.nextRun).add("retries", (Object)this.retries).add("errors", this.errors).toString();
    }

    public static ImmutableWebhookResult copyOf(WebhookResult instance) {
        if (instance instanceof ImmutableWebhookResult) {
            return (ImmutableWebhookResult)instance;
        }
        return ImmutableWebhookResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_STATUS = 2L;
        private static final long INIT_BIT_URL = 4L;
        private static final long INIT_BIT_EVENT_TOKEN = 8L;
        private static final long INIT_BIT_CREATED_AT = 16L;
        private static final long INIT_BIT_ACCEPTED_AT = 32L;
        private static final long INIT_BIT_RETRIES = 64L;
        private static final long INIT_BIT_ERRORS = 128L;
        private long initBits = 255L;
        @Nullable
        private String token;
        @Nullable
        private String status;
        @Nullable
        private String url;
        @Nullable
        private String eventToken;
        @Nullable
        private String createdAt;
        @Nullable
        private String acceptedAt;
        @Nullable
        private String nextRun;
        @Nullable
        private Integer retries;
        @Nullable
        private HashMap<String, Object> errors;

        private Builder() {
        }

        public final Builder from(WebhookResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.token(instance.token());
            this.status(instance.status());
            this.url(instance.url());
            this.eventToken(instance.eventToken());
            this.createdAt(instance.createdAt());
            this.acceptedAt(instance.acceptedAt());
            String nextRunValue = instance.nextRun();
            if (nextRunValue != null) {
                this.nextRun(nextRunValue);
            }
            this.retries(instance.retries());
            this.errors(instance.errors());
            return this;
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder status(String status) {
            this.status = (String)Preconditions.checkNotNull((Object)status, (Object)"status");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder url(String url) {
            this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder eventToken(String eventToken) {
            this.eventToken = (String)Preconditions.checkNotNull((Object)eventToken, (Object)"eventToken");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder createdAt(String createdAt) {
            this.createdAt = (String)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder acceptedAt(String acceptedAt) {
            this.acceptedAt = (String)Preconditions.checkNotNull((Object)acceptedAt, (Object)"acceptedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder nextRun(@Nullable String nextRun) {
            this.nextRun = nextRun;
            return this;
        }

        public final Builder retries(Integer retries) {
            this.retries = (Integer)Preconditions.checkNotNull((Object)retries, (Object)"retries");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder errors(HashMap<String, Object> errors) {
            this.errors = (HashMap)Preconditions.checkNotNull(errors, (Object)"errors");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableWebhookResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebhookResult(this.token, this.status, this.url, this.eventToken, this.createdAt, this.acceptedAt, this.nextRun, this.retries, this.errors);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("eventToken");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("acceptedAt");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("retries");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("errors");
            }
            return "Cannot build WebhookResult, some of required attributes are not set " + attributes;
        }
    }
}

