/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.apuava.http.HttpStatus;
import org.wisepersist.pinpayments.ParamsHelper;
import org.wisepersist.pinpayments.api.ChargesApi;
import org.wisepersist.pinpayments.api.impl.AbstractBaseApi;
import org.wisepersist.pinpayments.pojo.Charge;
import org.wisepersist.pinpayments.pojo.ChargeListResponse;
import org.wisepersist.pinpayments.pojo.ChargeResponse;
import org.wisepersist.pinpayments.pojo.ImmutableChargeListResponse;
import org.wisepersist.pinpayments.pojo.SearchCriteria;

public class ChargesApiImpl
extends AbstractBaseApi
implements ChargesApi {
    private static final Logger log = LoggerFactory.getLogger(ChargesApiImpl.class);
    @Inject
    private ParamsHelper paramsHelper;

    @Override
    public final ChargeResponse create(Charge charge) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(charge);
        String url = this.getApiUrl();
        HttpResponse httpResponse = this.httpTransportForPost().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getChargeResponse(HttpStatus.CREATED, httpResponse);
    }

    @Override
    public final ChargeResponse capture(String chargeToken) throws IOException {
        String url = String.format("%s/%s/capture", this.getApiUrl(), chargeToken);
        HttpResponse httpResponse = this.httpTransportForPut().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getChargeResponse(HttpStatus.CREATED, httpResponse);
    }

    @Override
    public final ChargeListResponse list(int page) throws IOException {
        return this.executeList(this.getApiUrl(), ImmutableChargeListResponse.class);
    }

    @Override
    public final ChargeListResponse search(SearchCriteria searchCriteria) throws IOException {
        return this.executeSearch(this.getApiUrl(), searchCriteria, ImmutableChargeListResponse.class);
    }

    @Override
    public final ChargeResponse fetch(String chargeToken) throws IOException {
        String url = String.format("%s/%s", this.getApiUrl(), chargeToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getChargeResponse(HttpStatus.OK, httpResponse);
    }

    @Override
    protected final String getApiName() {
        return "charges";
    }
}

