/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.apuava.http.HttpStatus;
import org.wisepersist.pinpayments.ParamsHelper;
import org.wisepersist.pinpayments.api.CustomersApi;
import org.wisepersist.pinpayments.api.impl.AbstractBaseApi;
import org.wisepersist.pinpayments.pojo.Card;
import org.wisepersist.pinpayments.pojo.CardListResponse;
import org.wisepersist.pinpayments.pojo.CardResponse;
import org.wisepersist.pinpayments.pojo.ChargeListResponse;
import org.wisepersist.pinpayments.pojo.Customer;
import org.wisepersist.pinpayments.pojo.CustomerListResponse;
import org.wisepersist.pinpayments.pojo.CustomerResponse;
import org.wisepersist.pinpayments.pojo.DeletionResult;
import org.wisepersist.pinpayments.pojo.ImmutableCustomerListResponse;

public class CustomersApiImpl
extends AbstractBaseApi
implements CustomersApi {
    private static final Logger log = LoggerFactory.getLogger(CustomersApiImpl.class);
    @Inject
    private ParamsHelper paramsHelper;

    @Override
    public final CustomerResponse create(Customer customer) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(customer);
        String url = this.getApiUrl();
        HttpResponse httpResponse = this.httpTransportForPost().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getCustomerResponse(HttpStatus.CREATED, httpResponse);
    }

    @Override
    public final CustomerListResponse list(int page) throws IOException {
        return this.executeList(this.getApiUrl(), ImmutableCustomerListResponse.class);
    }

    @Override
    public final CustomerResponse fetch(String customerToken) throws IOException {
        String url = String.format("%s/%s", this.getApiUrl(), customerToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getCustomerResponse(HttpStatus.OK, httpResponse);
    }

    @Override
    public final CustomerResponse update(String customerToken, Customer customer) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(customer);
        String url = String.format("%s/%s", this.getApiUrl(), customerToken);
        HttpResponse httpResponse = this.httpTransportForPut().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getCustomerResponse(HttpStatus.OK, httpResponse);
    }

    @Override
    public final DeletionResult delete(String customerToken) throws IOException {
        String url = String.format("%s/%s", this.getApiUrl(), customerToken);
        HttpResponse httpResponse = this.httpTransportForDelete().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getDeletionResult(httpResponse);
    }

    @Override
    public final ChargeListResponse listCharges(String customerToken, int page) throws IOException {
        String url = String.format("%s/%s/charges", this.getApiUrl(), customerToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getChargeListResponse(httpResponse);
    }

    @Override
    public final CardListResponse listCards(String customerToken, int page) throws IOException {
        String url = String.format("%s/%s/cards", this.getApiUrl(), customerToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getCardListResponse(HttpStatus.OK, httpResponse);
    }

    @Override
    public final CardResponse createCard(String customerToken, Card card) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(card);
        String url = String.format("%s/%s/cards", this.getApiUrl(), customerToken);
        HttpResponse httpResponse = this.httpTransportForPost().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getCardResponse(HttpStatus.CREATED, httpResponse);
    }

    @Override
    public final DeletionResult deleteCard(String customerToken, String cardToken) throws IOException {
        String url = String.format("%s/%s/cards/%s", this.getApiUrl(), customerToken, cardToken);
        HttpResponse httpResponse = this.httpTransportForDelete().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return this.getDeletionResult(httpResponse);
    }

    @Override
    protected final String getApiName() {
        return "customers";
    }
}

