/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.pinpayments.ParamsHelper;
import org.wisepersist.pinpayments.api.RecipientsApi;
import org.wisepersist.pinpayments.api.impl.AbstractBaseApi;
import org.wisepersist.pinpayments.pojo.ImmutableRecipientListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableRecipientResponse;
import org.wisepersist.pinpayments.pojo.ImmutableTransferListResponse;
import org.wisepersist.pinpayments.pojo.Recipient;
import org.wisepersist.pinpayments.pojo.RecipientListResponse;
import org.wisepersist.pinpayments.pojo.RecipientResponse;
import org.wisepersist.pinpayments.pojo.TransferListResponse;

public class RecipientsApiImpl
extends AbstractBaseApi
implements RecipientsApi {
    private static final Logger log = LoggerFactory.getLogger(RecipientsApiImpl.class);
    @Inject
    private ParamsHelper paramsHelper;
    @Inject
    private Gson gson;

    @Override
    public final RecipientResponse create(Recipient recipient) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(recipient);
        String url = this.getApiUrl();
        HttpResponse httpResponse = this.httpTransportForPost().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return (RecipientResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableRecipientResponse.class);
    }

    @Override
    public final RecipientListResponse list(int page) throws IOException {
        return this.executeList(this.getApiUrl(), ImmutableRecipientListResponse.class);
    }

    @Override
    public final RecipientResponse fetch(String recipientToken) throws IOException {
        String url = String.format("%s/%s", this.getApiUrl(), recipientToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (RecipientResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableRecipientResponse.class);
    }

    @Override
    public final RecipientResponse update(String recipientToken, Recipient recipient) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(recipient);
        String url = String.format("%s/%s", this.getApiUrl(), recipientToken);
        HttpResponse httpResponse = this.httpTransportForPut().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return (RecipientResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableRecipientResponse.class);
    }

    @Override
    public final TransferListResponse listTransfers(String recipientToken, int page) throws IOException {
        String url = String.format("%s/%s/transfers", this.getApiUrl(), recipientToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (TransferListResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableTransferListResponse.class);
    }

    @Override
    protected final String getApiName() {
        return "recipients";
    }
}

