/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.CardResult;
import org.wisepersist.pinpayments.pojo.CustomerResult;
import org.wisepersist.pinpayments.pojo.ImmutableCustomerResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersCustomerResult
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (CustomerResultTypeAdapter.adapts(type)) {
            return new CustomerResultTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersCustomerResult(CustomerResult)";
    }

    private static class CustomerResultTypeAdapter
    extends TypeAdapter<CustomerResult> {
        public final CardResult cardTypeSample = null;
        private final TypeAdapter<CardResult> cardTypeAdapter;

        CustomerResultTypeAdapter(Gson gson) {
            this.cardTypeAdapter = gson.getAdapter(CardResult.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return CustomerResult.class == type.getRawType() || ImmutableCustomerResult.class == type.getRawType();
        }

        public void write(JsonWriter out, CustomerResult value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeCustomerResult(out, value);
            }
        }

        public CustomerResult read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readCustomerResult(in);
        }

        private void writeCustomerResult(JsonWriter out, CustomerResult instance) throws IOException {
            out.beginObject();
            out.name("token");
            out.value(instance.token());
            out.name("created_at");
            out.value(instance.createdAt());
            out.name("card");
            this.cardTypeAdapter.write(out, (Object)instance.card());
            out.name("email");
            out.value(instance.email());
            out.endObject();
        }

        private CustomerResult readCustomerResult(JsonReader in) throws IOException {
            ImmutableCustomerResult.Builder builder = ImmutableCustomerResult.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableCustomerResult.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 't': {
                    if (!"token".equals(attributeName)) break;
                    this.readInToken(in, builder);
                    return;
                }
                case 'c': {
                    if ("created_at".equals(attributeName)) {
                        this.readInCreatedAt(in, builder);
                        return;
                    }
                    if (!"card".equals(attributeName)) break;
                    this.readInCard(in, builder);
                    return;
                }
                case 'e': {
                    if (!"email".equals(attributeName)) break;
                    this.readInEmail(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInToken(JsonReader in, ImmutableCustomerResult.Builder builder) throws IOException {
            builder.token(in.nextString());
        }

        private void readInCreatedAt(JsonReader in, ImmutableCustomerResult.Builder builder) throws IOException {
            builder.createdAt(in.nextString());
        }

        private void readInCard(JsonReader in, ImmutableCustomerResult.Builder builder) throws IOException {
            CardResult value = (CardResult)this.cardTypeAdapter.read(in);
            builder.card(value);
        }

        private void readInEmail(JsonReader in, ImmutableCustomerResult.Builder builder) throws IOException {
            builder.email(in.nextString());
        }
    }
}

