/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ImmutableTransferLineItem;
import org.wisepersist.pinpayments.pojo.TransferLineItem;

@ParametersAreNonnullByDefault
public final class GsonAdaptersTransferLineItem
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (TransferLineItemTypeAdapter.adapts(type)) {
            return new TransferLineItemTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersTransferLineItem(TransferLineItem)";
    }

    private static class TransferLineItemTypeAdapter
    extends TypeAdapter<TransferLineItem> {
        public final Integer amountTypeSample = null;
        private final TypeAdapter<Integer> amountTypeAdapter;

        TransferLineItemTypeAdapter(Gson gson) {
            this.amountTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return TransferLineItem.class == type.getRawType() || ImmutableTransferLineItem.class == type.getRawType();
        }

        public void write(JsonWriter out, TransferLineItem value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeTransferLineItem(out, value);
            }
        }

        public TransferLineItem read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readTransferLineItem(in);
        }

        private void writeTransferLineItem(JsonWriter out, TransferLineItem instance) throws IOException {
            out.beginObject();
            out.name("type");
            out.value(instance.type());
            String objectValue = instance.object();
            if (objectValue != null) {
                out.name("object");
                out.value(objectValue);
            } else if (out.getSerializeNulls()) {
                out.name("object");
                out.nullValue();
            }
            out.name("amount");
            this.amountTypeAdapter.write(out, (Object)instance.amount());
            out.endObject();
        }

        private TransferLineItem readTransferLineItem(JsonReader in) throws IOException {
            ImmutableTransferLineItem.Builder builder = ImmutableTransferLineItem.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableTransferLineItem.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 't': {
                    if (!"type".equals(attributeName)) break;
                    this.readInType(in, builder);
                    return;
                }
                case 'o': {
                    if (!"object".equals(attributeName)) break;
                    this.readInObject(in, builder);
                    return;
                }
                case 'a': {
                    if (!"amount".equals(attributeName)) break;
                    this.readInAmount(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInType(JsonReader in, ImmutableTransferLineItem.Builder builder) throws IOException {
            builder.type(in.nextString());
        }

        private void readInObject(JsonReader in, ImmutableTransferLineItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.object(in.nextString());
            }
        }

        private void readInAmount(JsonReader in, ImmutableTransferLineItem.Builder builder) throws IOException {
            Integer value = (Integer)this.amountTypeAdapter.read(in);
            builder.amount(value);
        }
    }
}

