/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ImmutableTransferLineItemResult;
import org.wisepersist.pinpayments.pojo.TransferLineItemResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersTransferLineItemResult
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (TransferLineItemResultTypeAdapter.adapts(type)) {
            return new TransferLineItemResultTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersTransferLineItemResult(TransferLineItemResult)";
    }

    private static class TransferLineItemResultTypeAdapter
    extends TypeAdapter<TransferLineItemResult> {
        public final Integer amountTypeSample = null;
        private final TypeAdapter<Integer> amountTypeAdapter;

        TransferLineItemResultTypeAdapter(Gson gson) {
            this.amountTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return TransferLineItemResult.class == type.getRawType() || ImmutableTransferLineItemResult.class == type.getRawType();
        }

        public void write(JsonWriter out, TransferLineItemResult value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeTransferLineItemResult(out, value);
            }
        }

        public TransferLineItemResult read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readTransferLineItemResult(in);
        }

        private void writeTransferLineItemResult(JsonWriter out, TransferLineItemResult instance) throws IOException {
            out.beginObject();
            String tokenValue = instance.token();
            if (tokenValue != null) {
                out.name("token");
                out.value(tokenValue);
            } else if (out.getSerializeNulls()) {
                out.name("token");
                out.nullValue();
            }
            out.name("created_at");
            out.value(instance.createdAt());
            out.name("type");
            out.value(instance.type());
            String objectValue = instance.object();
            if (objectValue != null) {
                out.name("object");
                out.value(objectValue);
            } else if (out.getSerializeNulls()) {
                out.name("object");
                out.nullValue();
            }
            out.name("amount");
            this.amountTypeAdapter.write(out, (Object)instance.amount());
            out.endObject();
        }

        private TransferLineItemResult readTransferLineItemResult(JsonReader in) throws IOException {
            ImmutableTransferLineItemResult.Builder builder = ImmutableTransferLineItemResult.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableTransferLineItemResult.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 't': {
                    if ("token".equals(attributeName)) {
                        this.readInToken(in, builder);
                        return;
                    }
                    if (!"type".equals(attributeName)) break;
                    this.readInType(in, builder);
                    return;
                }
                case 'c': {
                    if (!"created_at".equals(attributeName)) break;
                    this.readInCreatedAt(in, builder);
                    return;
                }
                case 'o': {
                    if (!"object".equals(attributeName)) break;
                    this.readInObject(in, builder);
                    return;
                }
                case 'a': {
                    if (!"amount".equals(attributeName)) break;
                    this.readInAmount(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInToken(JsonReader in, ImmutableTransferLineItemResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.token(in.nextString());
            }
        }

        private void readInCreatedAt(JsonReader in, ImmutableTransferLineItemResult.Builder builder) throws IOException {
            builder.createdAt(in.nextString());
        }

        private void readInType(JsonReader in, ImmutableTransferLineItemResult.Builder builder) throws IOException {
            builder.type(in.nextString());
        }

        private void readInObject(JsonReader in, ImmutableTransferLineItemResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.object(in.nextString());
            }
        }

        private void readInAmount(JsonReader in, ImmutableTransferLineItemResult.Builder builder) throws IOException {
            Integer value = (Integer)this.amountTypeAdapter.read(in);
            builder.amount(value);
        }
    }
}

