/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ImmutableWebhookListResponse;
import org.wisepersist.pinpayments.pojo.Pagination;
import org.wisepersist.pinpayments.pojo.WebhookListResponse;
import org.wisepersist.pinpayments.pojo.WebhookResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersWebhookListResponse
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (WebhookListResponseTypeAdapter.adapts(type)) {
            return new WebhookListResponseTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersWebhookListResponse(WebhookListResponse)";
    }

    private static class WebhookListResponseTypeAdapter
    extends TypeAdapter<WebhookListResponse> {
        public final WebhookResult responseTypeSample = null;
        public final Pagination paginationTypeSample = null;
        private final TypeAdapter<WebhookResult> responseTypeAdapter;
        private final TypeAdapter<Pagination> paginationTypeAdapter;

        WebhookListResponseTypeAdapter(Gson gson) {
            this.responseTypeAdapter = gson.getAdapter(WebhookResult.class);
            this.paginationTypeAdapter = gson.getAdapter(Pagination.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return WebhookListResponse.class == type.getRawType() || ImmutableWebhookListResponse.class == type.getRawType();
        }

        public void write(JsonWriter out, WebhookListResponse value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeWebhookListResponse(out, value);
            }
        }

        public WebhookListResponse read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readWebhookListResponse(in);
        }

        private void writeWebhookListResponse(JsonWriter out, WebhookListResponse instance) throws IOException {
            out.beginObject();
            List<WebhookResult> responseElements = instance.response();
            out.name("response");
            out.beginArray();
            for (WebhookResult e : responseElements) {
                this.responseTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.name("pagination");
            this.paginationTypeAdapter.write(out, (Object)instance.pagination());
            out.endObject();
        }

        private WebhookListResponse readWebhookListResponse(JsonReader in) throws IOException {
            ImmutableWebhookListResponse.Builder builder = ImmutableWebhookListResponse.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableWebhookListResponse.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'r': {
                    if (!"response".equals(attributeName)) break;
                    this.readInResponse(in, builder);
                    return;
                }
                case 'p': {
                    if (!"pagination".equals(attributeName)) break;
                    this.readInPagination(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInResponse(JsonReader in, ImmutableWebhookListResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    WebhookResult value = (WebhookResult)this.responseTypeAdapter.read(in);
                    builder.addResponse(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                WebhookResult value = (WebhookResult)this.responseTypeAdapter.read(in);
                builder.addResponse(value);
            }
        }

        private void readInPagination(JsonReader in, ImmutableWebhookListResponse.Builder builder) throws IOException {
            Pagination value = (Pagination)this.paginationTypeAdapter.read(in);
            builder.pagination(value);
        }
    }
}

