/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.CardResponse;
import org.wisepersist.pinpayments.pojo.CardResult;
import org.wisepersist.pinpayments.pojo.ErrorResponse;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableCardResponse
implements CardResponse {
    @Nullable
    private final CardResult response;
    @Nullable
    private final ErrorResponse errorResponse;

    private ImmutableCardResponse(@Nullable CardResult response, @Nullable ErrorResponse errorResponse) {
        this.response = response;
        this.errorResponse = errorResponse;
    }

    @Override
    @Nullable
    public CardResult response() {
        return this.response;
    }

    @Override
    @Nullable
    public ErrorResponse errorResponse() {
        return this.errorResponse;
    }

    public final ImmutableCardResponse withResponse(@Nullable CardResult value) {
        if (this.response == value) {
            return this;
        }
        return new ImmutableCardResponse(value, this.errorResponse);
    }

    public final ImmutableCardResponse withErrorResponse(@Nullable ErrorResponse value) {
        if (this.errorResponse == value) {
            return this;
        }
        return new ImmutableCardResponse(this.response, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCardResponse && this.equalTo((ImmutableCardResponse)another);
    }

    private boolean equalTo(ImmutableCardResponse another) {
        return Objects.equal((Object)this.response, (Object)another.response) && Objects.equal((Object)this.errorResponse, (Object)another.errorResponse);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.response});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.errorResponse});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CardResponse").omitNullValues().add("response", (Object)this.response).add("errorResponse", (Object)this.errorResponse).toString();
    }

    public static ImmutableCardResponse copyOf(CardResponse instance) {
        if (instance instanceof ImmutableCardResponse) {
            return (ImmutableCardResponse)instance;
        }
        return ImmutableCardResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private CardResult response;
        @Nullable
        private ErrorResponse errorResponse;

        private Builder() {
        }

        public final Builder from(CardResponse instance) {
            ErrorResponse errorResponseValue;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            CardResult responseValue = instance.response();
            if (responseValue != null) {
                this.response(responseValue);
            }
            if ((errorResponseValue = instance.errorResponse()) != null) {
                this.errorResponse(errorResponseValue);
            }
            return this;
        }

        public final Builder response(@Nullable CardResult response) {
            this.response = response;
            return this;
        }

        public final Builder errorResponse(@Nullable ErrorResponse errorResponse) {
            this.errorResponse = errorResponse;
            return this;
        }

        public ImmutableCardResponse build() {
            return new ImmutableCardResponse(this.response, this.errorResponse);
        }
    }
}

