/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.Card;
import org.wisepersist.pinpayments.pojo.Customer;
import org.wisepersist.pinpayments.pojo.CustomerBase;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableCustomer
implements Customer {
    @Nullable
    private final Card card;
    @Nullable
    private final String cardToken;
    private final String email;

    private ImmutableCustomer(@Nullable Card card, @Nullable String cardToken, String email) {
        this.card = card;
        this.cardToken = cardToken;
        this.email = email;
    }

    @Override
    @Nullable
    public Card card() {
        return this.card;
    }

    @Override
    @Nullable
    public String cardToken() {
        return this.cardToken;
    }

    @Override
    public String email() {
        return this.email;
    }

    public final ImmutableCustomer withCard(@Nullable Card value) {
        if (this.card == value) {
            return this;
        }
        return new ImmutableCustomer(value, this.cardToken, this.email);
    }

    public final ImmutableCustomer withCardToken(@Nullable String value) {
        if (Objects.equal((Object)this.cardToken, (Object)value)) {
            return this;
        }
        return new ImmutableCustomer(this.card, value, this.email);
    }

    public final ImmutableCustomer withEmail(String value) {
        if (this.email.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"email");
        return new ImmutableCustomer(this.card, this.cardToken, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCustomer && this.equalTo((ImmutableCustomer)another);
    }

    private boolean equalTo(ImmutableCustomer another) {
        return Objects.equal((Object)this.card, (Object)another.card) && Objects.equal((Object)this.cardToken, (Object)another.cardToken) && this.email.equals(another.email);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.card});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.cardToken});
        h += (h << 5) + this.email.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Customer").omitNullValues().add("card", (Object)this.card).add("cardToken", (Object)this.cardToken).add("email", (Object)this.email).toString();
    }

    public static ImmutableCustomer copyOf(Customer instance) {
        if (instance instanceof ImmutableCustomer) {
            return (ImmutableCustomer)instance;
        }
        return ImmutableCustomer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EMAIL = 1L;
        private long initBits = 1L;
        @Nullable
        private Card card;
        @Nullable
        private String cardToken;
        @Nullable
        private String email;

        private Builder() {
        }

        public final Builder from(Customer instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CustomerBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CustomerBase instance;
            if (object instanceof Customer) {
                String cardTokenValue;
                instance = (Customer)object;
                Card cardValue = instance.card();
                if (cardValue != null) {
                    this.card(cardValue);
                }
                if ((cardTokenValue = instance.cardToken()) != null) {
                    this.cardToken(cardTokenValue);
                }
            }
            if (object instanceof CustomerBase) {
                instance = (CustomerBase)object;
                this.email(instance.email());
            }
        }

        public final Builder card(@Nullable Card card) {
            this.card = card;
            return this;
        }

        public final Builder cardToken(@Nullable String cardToken) {
            this.cardToken = cardToken;
            return this;
        }

        public final Builder email(String email) {
            this.email = (String)Preconditions.checkNotNull((Object)email, (Object)"email");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCustomer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCustomer(this.card, this.cardToken, this.email);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("email");
            }
            return "Cannot build Customer, some of required attributes are not set " + attributes;
        }
    }
}

