/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.joda.time.DateTime;
import org.wisepersist.pinpayments.pojo.SearchCriteria;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableSearchCriteria
extends SearchCriteria {
    @Nullable
    private final String query;
    @Nullable
    private final DateTime startDate;
    @Nullable
    private final DateTime endDate;
    @Nullable
    private final String sort;
    private final int direction;

    private ImmutableSearchCriteria(Builder builder) {
        this.query = builder.query;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.sort = builder.sort;
        this.direction = builder.directionIsSet() ? builder.direction : super.direction();
    }

    private ImmutableSearchCriteria(@Nullable String query, @Nullable DateTime startDate, @Nullable DateTime endDate, @Nullable String sort, int direction) {
        this.query = query;
        this.startDate = startDate;
        this.endDate = endDate;
        this.sort = sort;
        this.direction = direction;
    }

    @Override
    @Nullable
    public String query() {
        return this.query;
    }

    @Override
    @Nullable
    public DateTime startDate() {
        return this.startDate;
    }

    @Override
    @Nullable
    public DateTime endDate() {
        return this.endDate;
    }

    @Override
    @Nullable
    public String sort() {
        return this.sort;
    }

    @Override
    public int direction() {
        return this.direction;
    }

    public final ImmutableSearchCriteria withQuery(@Nullable String value) {
        if (Objects.equal((Object)this.query, (Object)value)) {
            return this;
        }
        return new ImmutableSearchCriteria(value, this.startDate, this.endDate, this.sort, this.direction);
    }

    public final ImmutableSearchCriteria withStartDate(@Nullable DateTime value) {
        if (this.startDate == value) {
            return this;
        }
        return new ImmutableSearchCriteria(this.query, value, this.endDate, this.sort, this.direction);
    }

    public final ImmutableSearchCriteria withEndDate(@Nullable DateTime value) {
        if (this.endDate == value) {
            return this;
        }
        return new ImmutableSearchCriteria(this.query, this.startDate, value, this.sort, this.direction);
    }

    public final ImmutableSearchCriteria withSort(@Nullable String value) {
        if (Objects.equal((Object)this.sort, (Object)value)) {
            return this;
        }
        return new ImmutableSearchCriteria(this.query, this.startDate, this.endDate, value, this.direction);
    }

    public final ImmutableSearchCriteria withDirection(int value) {
        if (this.direction == value) {
            return this;
        }
        return new ImmutableSearchCriteria(this.query, this.startDate, this.endDate, this.sort, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchCriteria && this.equalTo((ImmutableSearchCriteria)another);
    }

    private boolean equalTo(ImmutableSearchCriteria another) {
        return Objects.equal((Object)this.query, (Object)another.query) && Objects.equal((Object)this.startDate, (Object)another.startDate) && Objects.equal((Object)this.endDate, (Object)another.endDate) && Objects.equal((Object)this.sort, (Object)another.sort) && this.direction == another.direction;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.query});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.startDate});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.endDate});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.sort});
        h += (h << 5) + this.direction;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SearchCriteria").omitNullValues().add("query", (Object)this.query).add("startDate", (Object)this.startDate).add("endDate", (Object)this.endDate).add("sort", (Object)this.sort).add("direction", this.direction).toString();
    }

    public static ImmutableSearchCriteria copyOf(SearchCriteria instance) {
        if (instance instanceof ImmutableSearchCriteria) {
            return (ImmutableSearchCriteria)instance;
        }
        return ImmutableSearchCriteria.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_DIRECTION = 1L;
        private long optBits;
        @Nullable
        private String query;
        @Nullable
        private DateTime startDate;
        @Nullable
        private DateTime endDate;
        @Nullable
        private String sort;
        private int direction;

        private Builder() {
        }

        public final Builder from(SearchCriteria instance) {
            String sortValue;
            DateTime endDateValue;
            DateTime startDateValue;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            String queryValue = instance.query();
            if (queryValue != null) {
                this.query(queryValue);
            }
            if ((startDateValue = instance.startDate()) != null) {
                this.startDate(startDateValue);
            }
            if ((endDateValue = instance.endDate()) != null) {
                this.endDate(endDateValue);
            }
            if ((sortValue = instance.sort()) != null) {
                this.sort(sortValue);
            }
            this.direction(instance.direction());
            return this;
        }

        public final Builder query(@Nullable String query) {
            this.query = query;
            return this;
        }

        public final Builder startDate(@Nullable DateTime startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Builder endDate(@Nullable DateTime endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Builder sort(@Nullable String sort) {
            this.sort = sort;
            return this;
        }

        public final Builder direction(int direction) {
            this.direction = direction;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableSearchCriteria build() {
            return new ImmutableSearchCriteria(this);
        }

        private boolean directionIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

