/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class BaseEntity<T extends BaseEntity<T>>
implements Serializable {
    protected boolean areEqual(Object o1, Object o2) {
        return !(o1 == null ? o2 != null : !o1.equals(o2));
    }

    protected boolean areEqual(String s1, String s2, boolean ignoreCase) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return ignoreCase ? s1.equalsIgnoreCase(s2) : s1.equals(s2);
    }

    protected boolean areEqual(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        return d1.getTime() == d2.getTime();
    }

    protected boolean areEqual(float f1, float f2) {
        return Float.floatToIntBits(f1) == Float.floatToIntBits(f2);
    }

    protected int calculateHashCode(Object ... values) {
        return Objects.hashCode((Object[])values);
    }

    public final int hashCode() {
        return this.calculateHashCode(this.getHashCodeData());
    }

    protected abstract Object[] getHashCodeData();

    protected abstract T getThis();

    public abstract Serializable getPk();

    public final boolean equals(Object other) {
        Serializable otherPk;
        if (this == other) {
            return true;
        }
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        if (this.getPk() != null && (otherPk = ((BaseEntity)other).getPk()) != null) {
            return this.getPk().equals(otherPk);
        }
        return this.dataEquals((BaseEntity)other);
    }

    protected abstract boolean dataEquals(T var1);
}

