/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerFactoryProvider {
    private static final Logger log = LoggerFactory.getLogger(EntityManagerFactoryProvider.class);
    private static final Map<String, EntityManagerFactory> cache = Maps.newHashMap();

    public static EntityManagerFactory get(String persistUnit) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)persistUnit) ? 1 : 0) != 0, (Object)"persistUnit cannot be null or empty");
        EntityManagerFactory emf = cache.get(persistUnit);
        if (emf == null) {
            emf = Persistence.createEntityManagerFactory((String)persistUnit);
            cache.put(persistUnit, emf);
            log.info("Initialized entity manager factory for persist unit '" + persistUnit + "'.");
        }
        return emf;
    }
}

