/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist;

import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCloseableEntityManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AutoCloseableEntityManager.class);
    private final EntityManager em;

    public AutoCloseableEntityManager(EntityManager em) {
        this.em = em;
    }

    public EntityManager em() {
        return this.em;
    }

    @Override
    public void close() {
        if (this.em != null && this.em.isOpen()) {
            try {
                this.em.close();
            }
            catch (Exception e) {
                log.warn("Error closing entity manager", (Throwable)e);
            }
        }
    }
}

