/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.AbstractDao;
import org.wisepersist.DaoException;

public class DaoMethodInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DaoMethodInterceptor.class);
    private final EntityManagerFactory emf;
    private final boolean useTransaction;

    public DaoMethodInterceptor(EntityManagerFactory emf, boolean useTransaction) {
        this.emf = emf;
        this.useTransaction = useTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        EntityManager entityManager = this.emf.createEntityManager();
        Object dao = invocation.getThis();
        Method daoMethod = invocation.getMethod();
        if (!AbstractDao.class.isAssignableFrom(dao.getClass())) {
            throw new IllegalStateException(dao.getClass().getName() + " must extend " + AbstractDao.class.getName());
        }
        Method setMethod = dao.getClass().getMethod("setEntityManager", EntityManager.class);
        try {
            setMethod.invoke(dao, entityManager);
        }
        catch (InvocationTargetException e) {
            throw new DaoException(String.format("%s.%s cannot be nested", daoMethod.getDeclaringClass(), daoMethod.getName()), e);
        }
        if (this.useTransaction) {
            entityManager.getTransaction().begin();
        }
        Object result = invocation.proceed();
        if (this.useTransaction) {
            entityManager.getTransaction().commit();
        }
        Object object = result;
        try {
            if (entityManager != null && entityManager.isOpen()) {
                entityManager.close();
            }
        }
        catch (Throwable throwable) {
            setMethod.invoke(dao, new Object[]{null});
            throw throwable;
        }
        setMethod.invoke(dao, new Object[]{null});
        return object;
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                if (this.useTransaction) {
                    entityManager.getTransaction().rollback();
                }
                throw new DaoException(String.format("Failed to execute %s.%s, rolled back", daoMethod.getDeclaringClass(), daoMethod.getName()), e);
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null && entityManager.isOpen()) {
                        entityManager.close();
                    }
                }
                catch (Throwable throwable2) {
                    setMethod.invoke(dao, new Object[]{null});
                    throw throwable2;
                }
                setMethod.invoke(dao, new Object[]{null});
                throw throwable;
            }
        }
    }
}

