/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.DaoException;
import org.wisepersist.DataSourceProvider;

public class EntityManagerFactoryProvider {
    private static final Logger log = LoggerFactory.getLogger(EntityManagerFactoryProvider.class);
    private static final Map<String, EntityManagerFactory> cache = Maps.newHashMap();

    public static EntityManagerFactory get(String persistUnit) {
        return EntityManagerFactoryProvider.get(persistUnit, null, null);
    }

    public static EntityManagerFactory get(String persistUnit, DataSourceProvider dsProvider, Map<String, Object> additionalProperties) {
        EntityManagerFactory emf;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)persistUnit) ? 1 : 0) != 0, (Object)"persistUnit cannot be null or empty");
        if (additionalProperties == null) {
            additionalProperties = Maps.newHashMap();
        }
        if ((emf = cache.get(persistUnit)) == null) {
            try {
                emf = Persistence.createEntityManagerFactory((String)persistUnit, (Map)additionalProperties);
                if (dsProvider != null) {
                    EntityManager em = emf.createEntityManager();
                    Map properties = emf.getProperties();
                    String jdbcUrl = (String)properties.get("javax.persistence.jdbc.url");
                    String jdbcDriver = (String)properties.get("javax.persistence.jdbc.driver");
                    String jdbcUser = (String)properties.get("javax.persistence.jdbc.user");
                    String jdbcPass = (String)properties.get("javax.persistence.jdbc.password");
                    em.close();
                    emf.close();
                    DataSource dataSource = dsProvider.get(jdbcUrl, jdbcDriver, jdbcUser, jdbcPass);
                    additionalProperties.put("javax.persistence.nonJtaDataSource", dataSource);
                    emf = Persistence.createEntityManagerFactory((String)persistUnit, (Map)additionalProperties);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new DaoException("Failed to create entity manager factory: " + e.getMessage(), e);
            }
            cache.put(persistUnit, emf);
            log.info("Initialized entity manager factory for persist unit '" + persistUnit + "'.");
        }
        return emf;
    }
}

