/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matchers;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.wisepersist.AutoCloseableEntityManagerProvider;
import org.wisepersist.DaoException;
import org.wisepersist.DaoMethodInterceptor;
import org.wisepersist.DataSourceProvider;
import org.wisepersist.EntityManagerFactoryProvider;
import org.wisepersist.NonTransactional;
import org.wisepersist.Transactional;

public class WisePersistModule
extends AbstractModule {
    private final EntityManagerFactory emf;

    public WisePersistModule(String persistUnit) {
        this(EntityManagerFactoryProvider.get(persistUnit));
    }

    public WisePersistModule(String persistUnit, Map<String, Object> additionalProperties) {
        this(EntityManagerFactoryProvider.get(persistUnit, null, additionalProperties));
    }

    public WisePersistModule(String persistUnit, DataSourceProvider dsProvider) {
        this(EntityManagerFactoryProvider.get(persistUnit, dsProvider, null));
    }

    public WisePersistModule(String persistUnit, DataSourceProvider dsProvider, Map<String, Object> additionalProperties) {
        this(EntityManagerFactoryProvider.get(persistUnit, dsProvider, additionalProperties));
    }

    public WisePersistModule(String persistUnit, DataSource dataSource, Map<String, Object> additionalProperties) {
        if (dataSource != null) {
            additionalProperties.put("javax.persistence.nonJtaDataSource", dataSource);
        }
        this.emf = Persistence.createEntityManagerFactory((String)persistUnit, additionalProperties);
    }

    public WisePersistModule(EntityManagerFactory emf) {
        Preconditions.checkArgument((emf != null ? 1 : 0) != 0, (Object)"EntityManagerFactory cannot be null");
        this.emf = emf;
    }

    protected void configure() {
        this.bind(AutoCloseableEntityManagerProvider.class).toInstance((Object)new AutoCloseableEntityManagerProvider(this.emf));
        DaoMethodInterceptor transactionalInterceptor = new DaoMethodInterceptor(this.emf, true);
        this.requestInjection(transactionalInterceptor);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{transactionalInterceptor});
        DaoMethodInterceptor nonTransactionalInterceptor = new DaoMethodInterceptor(this.emf, false);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(NonTransactional.class), new MethodInterceptor[]{nonTransactionalInterceptor});
    }

    public boolean equals(Object o) {
        boolean equals;
        boolean bl = equals = this == o || o != null && ((Object)((Object)this)).getClass() == o.getClass();
        if (equals) {
            throw new DaoException("Only one WisePersistModule can be created in one Guice injector. If you need to access multiple data sources, please create multiple separate Guice injectors.");
        }
        return false;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

