/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.core;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.woelker.jimix.core.AssetRequestHandler;
import org.woelker.jimix.core.HttpRequest;
import org.woelker.jimix.core.InventoryRequestHandler;
import org.woelker.jimix.core.MbeanRequestHandler;
import org.woelker.jimix.core.RequestHandler;

public class JimixRequestHandler
implements RequestHandler {
    ArrayList<DispatchEntry> dispatchList = new ArrayList();

    public JimixRequestHandler() {
        this.addDispatch("/api/inventory", new InventoryRequestHandler());
        this.addDispatch("/api/mbeans/([^/]+)", new MbeanRequestHandler());
        this.addDispatch(".*", new AssetRequestHandler());
    }

    @Override
    public void handle(HttpRequest httpRequest) throws Exception {
        httpRequest.setHeader("Access-Control-Allow-Origin", "*");
        if (httpRequest.getPathInfo() == null) {
            httpRequest.sendRedirect(httpRequest.getRequestURI() + "/");
            return;
        }
        String path = httpRequest.getPathInfo();
        for (DispatchEntry dispatchEntry : this.dispatchList) {
            Matcher matcher = dispatchEntry.pattern.matcher(path);
            if (!matcher.matches()) continue;
            for (int i = 0; i < matcher.groupCount(); ++i) {
                httpRequest.setAttribute("param-" + i, matcher.group(i + 1));
            }
            dispatchEntry.handler.handle(httpRequest);
            return;
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void addDispatch(String regex, RequestHandler handler) {
        this.dispatchList.add(new DispatchEntry(Pattern.compile("^" + regex + "$"), handler));
    }

    public static class DispatchEntry {
        Pattern pattern;
        RequestHandler handler;

        public DispatchEntry(Pattern pattern, RequestHandler handler) {
            this.pattern = pattern;
            this.handler = handler;
        }
    }
}

