/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.core;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import org.woelker.jimix.core.HttpRequest;
import org.woelker.jimix.core.JsonWriter;
import org.woelker.jimix.core.RequestHandler;

public class MbeanRequestHandler
implements RequestHandler {
    @Override
    public void handle(HttpRequest httpRequest) throws Exception {
        String objectName;
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectInstance> instances = mbeanServer.queryMBeans(new ObjectName(objectName = (String)httpRequest.getAttribute("param-0")), null);
        if (instances.isEmpty()) {
            httpRequest.sendError(404);
            return;
        }
        HashMap result = new HashMap();
        ObjectInstance instance = instances.iterator().next();
        MBeanInfo mBeanInfo = mbeanServer.getMBeanInfo(instance.getObjectName());
        ArrayList attributes = new ArrayList();
        result.put("attributes", attributes);
        for (MBeanAttributeInfo attributeInfo : mBeanInfo.getAttributes()) {
            HashMap<String, Object> attribute = new HashMap<String, Object>();
            attribute.put("name", attributeInfo.getName());
            attribute.put("type", attributeInfo.getType());
            attribute.put("description", attributeInfo.getDescription());
            try {
                attribute.put("value", mbeanServer.getAttribute(instance.getObjectName(), attributeInfo.getName()));
            }
            catch (RuntimeMBeanException ignored) {
                attribute.put("value", null);
            }
            attributes.add(attribute);
        }
        new JsonWriter(httpRequest.getOutputStream()).serialize(result);
    }
}

