/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.core;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;

class JsonWriter {
    private final OutputStream outputStream;
    private final Pattern quotePattern = Pattern.compile("[\"]");
    private final String quoteReplacement = Matcher.quoteReplacement("\\\"");
    private final Pattern backslashPattern = Pattern.compile("[\\\\]");
    private final String backslashReplacement = Matcher.quoteReplacement("\\\\");
    private final Pattern newlinePattern = Pattern.compile("\n");
    private final String newlineReplacement = Matcher.quoteReplacement("\\n");
    private final PrintWriter writer;

    public JsonWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.writer = new PrintWriter(outputStream);
    }

    void serialize(Object object) {
        this.serialize(object, 0);
        this.writer.flush();
    }

    private void serialize(Object object, int indentation) {
        if (object instanceof String) {
            this.serializeString((String)object);
        } else if (object instanceof Map) {
            this.serializeMap((Map)object, indentation);
        } else if (object instanceof List) {
            this.serializeList((List)object, indentation);
        } else if (object instanceof Object[]) {
            this.serializeList(Arrays.asList((Object[])object), indentation);
        } else if (object == null) {
            this.writer.print("null");
        } else if (object instanceof Number) {
            this.writer.print(object.toString());
        } else if (object instanceof Boolean) {
            this.writer.print(object.toString());
        } else if (object instanceof ObjectName) {
            this.serializeString(object.toString());
        } else {
            this.serializeString(object.toString());
        }
    }

    private void serializeMap(Map<Object, Object> map, int indentation) {
        this.writer.print("{");
        String comma = "";
        for (Map.Entry<Object, Object> value : map.entrySet()) {
            this.writer.println(comma);
            this.indent(indentation + 1);
            this.writer.print("\"");
            this.writer.print(value.getKey().toString());
            this.writer.print("\": ");
            this.serialize(value.getValue(), indentation + 1);
            comma = ",";
        }
        this.writer.println();
        this.indent(indentation);
        this.writer.print("}");
    }

    private void indent(int indentation) {
        for (int i = 0; i < indentation; ++i) {
            this.writer.print("\t");
        }
    }

    private void serializeList(List list, int indentation) {
        this.writer.print("[");
        String comma = "";
        for (Object value : list) {
            this.writer.println(comma);
            this.indent(indentation + 1);
            this.serialize(value, indentation + 1);
            comma = ",";
        }
        this.writer.println();
        this.indent(indentation);
        this.writer.print("]");
    }

    private void serializeString(String string) {
        this.writer.print("\"");
        String backslashesReplaced = this.backslashPattern.matcher(string).replaceAll(this.backslashReplacement);
        String quotesReplaced = this.quotePattern.matcher(backslashesReplaced).replaceAll(this.quoteReplacement);
        String newlinesReplaced = this.newlinePattern.matcher(quotesReplaced).replaceAll(this.newlineReplacement);
        this.writer.print(newlinesReplaced);
        this.writer.print("\"");
    }
}

