/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.core;

import java.lang.management.ManagementFactory;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.woelker.jimix.core.HttpRequest;
import org.woelker.jimix.core.JsonWriter;
import org.woelker.jimix.core.RequestHandler;
import org.woelker.jimix.core.TypeCoercer;

public class MbeanOperationRequestHandler
implements RequestHandler {
    MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    TypeCoercer typeCoercer = new TypeCoercer();

    @Override
    public void handle(HttpRequest httpRequest) throws Exception {
        Set<ObjectInstance> instances;
        if ("PUT".equals(httpRequest.getMethod())) {
            this.handleSetAttribute(httpRequest);
            return;
        }
        String objectName = (String)httpRequest.getAttribute("param-0");
        String operationName = (String)httpRequest.getAttribute("param-1");
        ArrayList<String> arguments = new ArrayList<String>();
        String queryString = httpRequest.getQueryString();
        if (queryString != null) {
            String[] pairs;
            for (String string : pairs = queryString.split("&")) {
                int idx = string.indexOf("=");
                String name = URLDecoder.decode(string.substring(0, idx), "UTF-8");
                String value = URLDecoder.decode(string.substring(idx + 1), "UTF-8");
                if (!"argument".equals(name)) continue;
                arguments.add(value);
            }
        }
        if ((instances = this.mbeanServer.queryMBeans(new ObjectName(objectName), null)).isEmpty()) {
            httpRequest.sendError(404);
            return;
        }
        ObjectInstance instance = instances.iterator().next();
        MBeanInfo mBeanInfo = this.mbeanServer.getMBeanInfo(instance.getObjectName());
        String[] signature = new String[]{};
        for (MBeanOperationInfo operation : mBeanInfo.getOperations()) {
            if (arguments.size() != operation.getSignature().length) continue;
            ArrayList<String> parameters = new ArrayList<String>();
            for (MBeanParameterInfo parameter : operation.getSignature()) {
                parameters.add(parameter.getType());
            }
            signature = parameters.toArray(signature);
            break;
        }
        Object[] objectArray = new Object[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            Object value;
            objectArray[i] = value = this.typeCoercer.coerce((String)arguments.get(i), signature[i]);
        }
        Object invocationResult = this.mbeanServer.invoke(instance.getObjectName(), operationName, objectArray, signature);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", invocationResult);
        new JsonWriter(httpRequest.getOutputStream()).serialize(result);
    }

    private void handleSetAttribute(HttpRequest httpRequest) throws Exception {
        Set<ObjectInstance> instances;
        String objectName = (String)httpRequest.getAttribute("param-0");
        String attributeName = (String)httpRequest.getAttribute("param-1");
        String newValueString = null;
        String queryString = httpRequest.getQueryString();
        if (queryString != null) {
            String[] pairs;
            for (String pair : pairs = queryString.split("&")) {
                int idx = pair.indexOf("=");
                String name = URLDecoder.decode(pair.substring(0, idx), "UTF-8");
                String value = URLDecoder.decode(pair.substring(idx + 1), "UTF-8");
                if (!"value".equals(name)) continue;
                newValueString = value;
            }
        }
        if ((instances = this.mbeanServer.queryMBeans(new ObjectName(objectName), null)).isEmpty()) {
            httpRequest.sendError(404);
            return;
        }
        ObjectInstance instance = instances.iterator().next();
        Object newValue = null;
        MBeanInfo mBeanInfo = this.mbeanServer.getMBeanInfo(instance.getObjectName());
        for (MBeanAttributeInfo attribute : mBeanInfo.getAttributes()) {
            if (!attributeName.equals(attribute.getName())) continue;
            newValue = this.typeCoercer.coerce(newValueString, attribute.getType());
            break;
        }
        this.mbeanServer.setAttribute(instance.getObjectName(), new Attribute(attributeName, newValue));
    }
}

