/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.core;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

class TypeCoercer {
    static Map<String, Class<?>> primitiveTypeMap = new HashMap();

    TypeCoercer() {
    }

    Object coerce(String string, Class<?> cls) {
        try {
            if (cls == String.class) {
                return string;
            }
            Constructor<?> stringConstructor = cls.getConstructor(String.class);
            if (stringConstructor != null) {
                return stringConstructor.newInstance(string);
            }
            throw new RuntimeException("Unable to coerce '" + string + "' to class " + cls.getName());
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to coerce '" + string + "' to class " + cls.getName(), ex);
        }
    }

    Object coerce(String input, String className) {
        Class<?> cls = this.classForName(className);
        return this.coerce(input, cls);
    }

    private Class<?> classForName(String className) {
        try {
            Class<?> cls = primitiveTypeMap.get(className);
            if (cls != null) {
                return cls;
            }
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        primitiveTypeMap.put("byte", Byte.class);
        primitiveTypeMap.put("short", Short.TYPE);
        primitiveTypeMap.put("char", Character.class);
        primitiveTypeMap.put("int", Integer.class);
        primitiveTypeMap.put("long", Long.class);
        primitiveTypeMap.put("float", Float.class);
        primitiveTypeMap.put("double", Double.class);
        primitiveTypeMap.put("boolean", Boolean.class);
    }
}

