/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.core.logging;

import java.util.logging.Level;
import org.woelker.jimix.core.logging.Logger;

class JuliLogger
implements Logger {
    protected final java.util.logging.Logger delegate;
    private static final int METHODNAME_DEPTH = 3;

    JuliLogger(Class clazz) {
        this.delegate = java.util.logging.Logger.getLogger(clazz.getName());
    }

    @Override
    public void info(String logMessage) {
        this.log(Level.INFO, logMessage);
    }

    @Override
    public void debug(String logMessage) {
        this.log(Level.FINE, logMessage);
    }

    @Override
    public void warn(String logMessage) {
        this.log(Level.WARNING, logMessage);
    }

    @Override
    public void warn(String logMessage, Throwable throwable) {
        this.log(Level.WARNING, logMessage, throwable);
    }

    @Override
    public void error(String logMessage) {
        this.log(Level.SEVERE, logMessage);
    }

    @Override
    public void error(String logMessage, Throwable throwable) {
        this.log(Level.SEVERE, logMessage, throwable);
    }

    private void log(Level level, String logMessage, Throwable throwable) {
        if (this.delegate.isLoggable(level)) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StackTraceElement element = stackTrace[3];
            String methodName = element.getMethodName();
            String className = element.getClassName();
            this.delegate.logp(level, className, methodName, logMessage, throwable);
        }
    }

    private void log(Level level, String logMessage) {
        if (this.delegate.isLoggable(level)) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StackTraceElement element = stackTrace[3];
            String methodName = element.getMethodName();
            String className = element.getClassName();
            this.delegate.logp(level, className, methodName, logMessage);
        }
    }
}

