/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.woelker.jimix.core.AssetRequestHandler;
import org.woelker.jimix.core.HttpRequest;
import org.woelker.jimix.core.InventoryRequestHandler;
import org.woelker.jimix.core.JsonWriter;
import org.woelker.jimix.core.MbeanOperationRequestHandler;
import org.woelker.jimix.core.MbeanRequestHandler;
import org.woelker.jimix.core.RequestHandler;
import org.woelker.jimix.core.logging.Logger;
import org.woelker.jimix.core.logging.LoggerFactory;

public class JimixRequestHandler
implements RequestHandler {
    private final Logger logger = LoggerFactory.createLogger(JimixRequestHandler.class);
    ArrayList<DispatchEntry> dispatchList = new ArrayList();

    public JimixRequestHandler() {
        this.addDispatch("/api/inventory", new InventoryRequestHandler());
        this.addDispatch("/api/mbeans/([^/]+)", new MbeanRequestHandler());
        this.addDispatch("/api/mbeans/([^/]+)/(.+)", new MbeanOperationRequestHandler());
        this.addDispatch(".*", new AssetRequestHandler());
        this.logger.info("Created jimix request handler");
    }

    @Override
    public void handle(HttpRequest httpRequest) throws Exception {
        try {
            httpRequest.setHeader("Access-Control-Allow-Origin", "*");
            if (httpRequest.getPathInfo() == null || httpRequest.getPathInfo().length() == 0) {
                httpRequest.sendRedirect(httpRequest.getRequestURI() + "/");
                return;
            }
            String path = httpRequest.getPathInfo();
            for (DispatchEntry dispatchEntry : this.dispatchList) {
                Matcher matcher = dispatchEntry.pattern.matcher(path);
                if (!matcher.matches()) continue;
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    httpRequest.setAttribute("param-" + i, matcher.group(i + 1));
                }
                dispatchEntry.handler.handle(httpRequest);
                return;
            }
        }
        catch (Throwable throwable) {
            this.logger.warn("Error handling request", throwable);
            httpRequest.setStatus(500);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("message", throwable.getMessage());
            new JsonWriter(httpRequest.getOutputStream()).serialize(result);
        }
    }

    private void addDispatch(String regex, RequestHandler handler) {
        this.dispatchList.add(new DispatchEntry(Pattern.compile("^" + regex + "$"), handler));
    }

    public static class DispatchEntry {
        Pattern pattern;
        RequestHandler handler;

        public DispatchEntry(Pattern pattern, RequestHandler handler) {
            this.pattern = pattern;
            this.handler = handler;
        }
    }
}

