/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.samples.jetty;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.woelker.jimix.servlet.JimixServlet;

public class JimixSampleJetty {
    public static void main(String[] args) throws Exception {
        new JimixSampleJetty().run();
    }

    private void run() throws Exception {
        this.addSampleMetrics();
        ManagementFactory.getPlatformMBeanServer().registerMBean(new Hello(), new ObjectName("asdf:type=bar"));
        Server server = new Server(8080);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new JimixServlet()), "/jimix/*");
        server.start();
        server.join();
    }

    private void addSampleMetrics() {
        Metrics.newGauge(JimixSampleJetty.class, (String)"foo", (Gauge)new Gauge<Long>(){
            long current = 0L;

            public Long value() {
                return this.current++;
            }
        });
        Metrics.newGauge(JimixSampleJetty.class, (String)"foo", (String)"bar", (Gauge)new Gauge<Long>(){
            long current = 0L;

            public Long value() {
                return this.current++;
            }
        });
        MetricName metricName = new MetricName("fizzfizzfizzfizzfizzfizzfizzfizz fizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizz fizzfizzfizzfizzfizzfizzfizzfizz", "buzz", "foofoofoofoofoofoofoofoofoofoofoo foofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoo foofoofoofoofoofoo");
        Metrics.newGauge((MetricName)metricName, (Gauge)new Gauge<Long>(){
            long current = 0L;

            public Long value() {
                return this.current++;
            }
        });
        MetricName metricNameString = new MetricName("fizz", "buzz", "foo");
        Metrics.newGauge((MetricName)metricNameString, (Gauge)new Gauge<String>(){

            public String value() {
                return "fizzfizzfizzfizzfizzfizzfizzfizz fizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizz fizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizz fizzfizzfizzfizzfizzfizzfizzfizz fizzfizzfizzfizzfizzfizzfizzfizz";
            }
        });
        MetricName metricNameArray = new MetricName("fizz", "buzz", "array");
        Metrics.newGauge((MetricName)metricNameArray, (Gauge)new Gauge<String[]>(){

            public String[] value() {
                return Arrays.asList("fizzfizzfizzfizzfizzfizzfizzfizz", "fizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizz", "fizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizz", "fizzfizzfizzfizzfizzfizzfizzfizz", "fizzfizzfizzfizzfizzfizzfizzfizz").toArray(new String[0]);
            }
        });
    }

    public static interface HelloMBean {
        public void sayHello();

        public String createGreeting();

        public void alwaysFails();

        public String takes3seconds() throws InterruptedException;

        public String getMessage();

        public void setMessage(String var1);
    }

    public static class Hello
    implements HelloMBean {
        private String message = "Hello World";

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public void sayHello() {
            System.out.println(this.message);
        }

        @Override
        public String createGreeting() {
            System.out.println("Creating greeting");
            return this.message;
        }

        @Override
        public void alwaysFails() {
            throw new RuntimeException("always broken");
        }

        @Override
        public String takes3seconds() throws InterruptedException {
            Thread.sleep(3000L);
            return this.message;
        }

        @Override
        public void setMessage(String message) {
            this.message = message;
        }
    }
}

