/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.samples.jetty;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Date;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.woelker.jimix.servlet.JimixServlet;

public class JimixSampleJetty {
    public static void main(String[] args) throws Exception {
        new JimixSampleJetty().run();
    }

    private void run() throws Exception {
        this.addSampleMetrics();
        ManagementFactory.getPlatformMBeanServer().registerMBean(new Hello(), new ObjectName("asdf:name=bar"));
        Server server = new Server(8080);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new JimixServlet()), "/jimix/*");
        server.start();
        server.join();
    }

    private void addSampleMetrics() {
        Metrics.newGauge(JimixSampleJetty.class, (String)"foo", (Gauge)new Gauge<Long>(){
            long current = 0L;

            public Long value() {
                return this.current++;
            }
        });
        Metrics.newGauge(JimixSampleJetty.class, (String)"foo", (String)"bar", (Gauge)new Gauge<Long>(){
            long current = 0L;

            public Long value() {
                return this.current++;
            }
        });
        MetricName metricName = new MetricName("fizzfizzfizzfizzfizzfizzfizzfizz fizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizz fizzfizzfizzfizzfizzfizzfizzfizz", "buzz", "foofoofoofoofoofoofoofoofoofoofoo foofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoofoo foofoofoofoofoofoo");
        Metrics.newGauge((MetricName)metricName, (Gauge)new Gauge<Long>(){
            long current = 0L;

            public Long value() {
                return this.current++;
            }
        });
        MetricName metricNameString = new MetricName("fizz", "buzz", "foo");
        Metrics.newGauge((MetricName)metricNameString, (Gauge)new Gauge<String>(){

            public String value() {
                return "fizzfizzfizzfizzfizzfizzfizzfizz fizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizz fizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizz fizzfizzfizzfizzfizzfizzfizzfizz fizzfizzfizzfizzfizzfizzfizzfizz";
            }
        });
        MetricName metricNameArray = new MetricName("fizz", "buzz", "array");
        Metrics.newGauge((MetricName)metricNameArray, (Gauge)new Gauge<String[]>(){

            public String[] value() {
                return Arrays.asList("fizzfizzfizzfizzfizzfizzfizzfizz", "fizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizz", "fizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizzfizz", "fizzfizzfizzfizzfizzfizzfizzfizz", "fizzfizzfizzfizzfizzfizzfizzfizz").toArray(new String[0]);
            }
        });
    }

    public static interface HelloMBean {
        public void sayHello();

        public String createGreeting();

        public void alwaysFails();

        public String takes3seconds() throws InterruptedException;

        public String takesLotsOfParameters(String var1, Integer var2, Float var3, Boolean var4);

        public String getMessage();

        public void setMessage(String var1);

        public String getReadOnly();

        public String getMessageError();

        public void setMessageError(String var1);

        public String getDate();

        public long getTimeInMillis();

        public double getRandom();
    }

    public static class Hello
    implements HelloMBean {
        private String message = "Hello World";

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public void sayHello() {
            System.out.println(this.message);
        }

        @Override
        public String createGreeting() {
            System.out.println("Creating greeting");
            return this.message;
        }

        @Override
        public void alwaysFails() {
            throw new RuntimeException("always broken");
        }

        @Override
        public String takes3seconds() throws InterruptedException {
            Thread.sleep(3000L);
            return this.message;
        }

        @Override
        public void setMessage(String message) {
            System.out.println("message was set to " + message);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            this.message = message;
        }

        @Override
        public String takesLotsOfParameters(String string, Integer integer, Float f, Boolean b) {
            System.out.println("string:  " + string);
            System.out.println("int:     " + integer);
            System.out.println("float:   " + f);
            System.out.println("boolean: " + b);
            return "Success";
        }

        @Override
        public String getReadOnly() {
            return "readonly";
        }

        @Override
        public String getMessageError() {
            return this.message;
        }

        @Override
        public void setMessageError(String message) {
            throw new RuntimeException("always fail");
        }

        @Override
        public String getDate() {
            return new Date().toString();
        }

        @Override
        public long getTimeInMillis() {
            return System.currentTimeMillis();
        }

        @Override
        public double getRandom() {
            return Math.random();
        }
    }
}

