/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.core;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.woelker.jimix.core.HttpRequest;
import org.woelker.jimix.core.JsonWriter;
import org.woelker.jimix.core.RequestHandler;

public class MbeanOperationRequestHandler
implements RequestHandler {
    MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    @Override
    public void handle(HttpRequest httpRequest) throws Exception {
        String objectName = (String)httpRequest.getAttribute("param-0");
        String operationName = (String)httpRequest.getAttribute("param-1");
        Set<ObjectInstance> instances = this.mbeanServer.queryMBeans(new ObjectName(objectName), null);
        if (instances.isEmpty()) {
            httpRequest.sendError(404);
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ObjectInstance instance = instances.iterator().next();
        MBeanInfo mBeanInfo = this.mbeanServer.getMBeanInfo(instance.getObjectName());
        Object invocationResult = this.mbeanServer.invoke(instance.getObjectName(), operationName, new Object[0], new String[0]);
        result.put("result", invocationResult);
        new JsonWriter(httpRequest.getOutputStream()).serialize(result);
    }
}

