/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.core;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.woelker.jimix.core.HttpRequest;
import org.woelker.jimix.core.JsonWriter;
import org.woelker.jimix.core.RequestHandler;

public class InventoryRequestHandler
implements RequestHandler {
    private final String userName = System.getProperty("user.name", "<unknownUser>");
    private String hostName = "<unknownHost>";
    private String mainClass = "<unknown Main Class>";

    public InventoryRequestHandler() {
        try {
            InetAddress iAddress = InetAddress.getLocalHost();
            this.hostName = iAddress.getHostName();
            this.hostName = iAddress.getCanonicalHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mainClass = this.getMainClass();
    }

    private String getMainClass() {
        String mainClass = "<unknown Main Class>";
        Map<Thread, StackTraceElement[]> threadMap = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : threadMap.entrySet()) {
            StackTraceElement[] stackTraceElements;
            StackTraceElement stackTraceElement;
            String name = entry.getKey().getName();
            if (!name.equals("main") || !(stackTraceElement = (stackTraceElements = entry.getValue())[stackTraceElements.length - 1]).getMethodName().equals("main")) continue;
            return stackTraceElement.getClassName();
        }
        return mainClass;
    }

    @Override
    public void handle(HttpRequest httpRequest) throws Exception {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectInstance> instances = mbeanServer.queryMBeans(null, null);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("userName", this.userName);
        result.put("hostName", this.hostName);
        result.put("mainClass", this.mainClass);
        ArrayList mbeanList = new ArrayList();
        result.put("mbeans", mbeanList);
        Iterator<ObjectInstance> iterator = instances.iterator();
        httpRequest.setContentType("application/json");
        while (iterator.hasNext()) {
            try {
                ObjectInstance instance = iterator.next();
                HashMap<String, Object> mbean = new HashMap<String, Object>();
                ObjectName objectName = instance.getObjectName();
                MBeanInfo mBeanInfo = mbeanServer.getMBeanInfo(objectName);
                String description = mBeanInfo.getDescription();
                mbean.put("objectName", objectName.getCanonicalName());
                mbean.put("description", description);
                ArrayList attributes = new ArrayList();
                mbean.put("attributes", attributes);
                mbeanList.add(mbean);
                for (MBeanAttributeInfo attributeInfo : mBeanInfo.getAttributes()) {
                    HashMap<String, String> attribute = new HashMap<String, String>();
                    attribute.put("name", attributeInfo.getName());
                    attribute.put("type", attributeInfo.getType());
                    attribute.put("description", attributeInfo.getDescription());
                    attributes.add(attribute);
                }
            }
            catch (Throwable throwable) {
            }
        }
        new JsonWriter(httpRequest.getOutputStream()).serialize(result);
    }
}

