/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.CaseInsensitiveMultiMap;
import org.vertx.java.core.http.HttpServerFileUpload;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.http.HttpVersion;
import org.vertx.java.core.http.impl.DefaultHttpServerFileUpload;
import org.vertx.java.core.http.impl.HttpHeadersAdapter;
import org.vertx.java.core.http.impl.ServerConnection;
import org.vertx.java.core.http.impl.UriParser;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.NetSocket;

public class DefaultHttpServerRequest
implements HttpServerRequest {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpServerRequest.class);
    private final ServerConnection conn;
    private final HttpRequest request;
    private final HttpServerResponse response;
    private HttpVersion version;
    private String method;
    private String uri;
    private String path;
    private String query;
    private Handler<Buffer> dataHandler;
    private Handler<Throwable> exceptionHandler;
    private MultiMap params;
    private MultiMap headers;
    private URI absoluteURI;
    private NetSocket netSocket;
    private Handler<HttpServerFileUpload> uploadHandler;
    private Handler<Void> endHandler;
    private MultiMap attributes;
    private HttpPostRequestDecoder decoder;
    private boolean isURLEncoded;

    DefaultHttpServerRequest(ServerConnection conn, HttpRequest request, HttpServerResponse response) {
        this.conn = conn;
        this.request = request;
        this.response = response;
    }

    @Override
    public HttpVersion version() {
        if (this.version == null) {
            io.netty.handler.codec.http.HttpVersion nettyVersion = this.request.getProtocolVersion();
            if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_0) {
                this.version = HttpVersion.HTTP_1_0;
            } else if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                this.version = HttpVersion.HTTP_1_1;
            } else {
                throw new IllegalStateException("Unsupported HTTP version: " + nettyVersion);
            }
        }
        return this.version;
    }

    @Override
    public String method() {
        if (this.method == null) {
            this.method = this.request.getMethod().toString();
        }
        return this.method;
    }

    @Override
    public String uri() {
        if (this.uri == null) {
            this.uri = this.request.getUri();
        }
        return this.uri;
    }

    @Override
    public String path() {
        if (this.path == null) {
            this.path = UriParser.path(this.uri());
        }
        return this.path;
    }

    @Override
    public String query() {
        if (this.query == null) {
            this.query = UriParser.query(this.uri());
        }
        return this.query;
    }

    @Override
    public HttpServerResponse response() {
        return this.response;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = new HttpHeadersAdapter(this.request.headers());
        }
        return this.headers;
    }

    @Override
    public MultiMap params() {
        if (this.params == null) {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri());
            Map prms = queryStringDecoder.parameters();
            this.params = new CaseInsensitiveMultiMap();
            if (!prms.isEmpty()) {
                for (Map.Entry entry : prms.entrySet()) {
                    this.params.add((String)entry.getKey(), (Iterable)entry.getValue());
                }
            }
        }
        return this.params;
    }

    @Override
    public HttpServerRequest dataHandler(Handler<Buffer> dataHandler) {
        this.dataHandler = dataHandler;
        return this;
    }

    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public HttpServerRequest pause() {
        this.conn.pause();
        return this;
    }

    @Override
    public HttpServerRequest resume() {
        this.conn.resume();
        return this;
    }

    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    @Override
    public URI absoluteURI() {
        if (this.absoluteURI == null) {
            try {
                URI uri = new URI(this.uri());
                String scheme = uri.getScheme();
                this.absoluteURI = scheme != null && (scheme.equals("http") || scheme.equals("https")) ? uri : new URI(this.conn.getServerOrigin() + uri);
            }
            catch (URISyntaxException e) {
                log.error("Failed to create abs uri", e);
            }
        }
        return this.absoluteURI;
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.getPeerCertificateChain();
    }

    @Override
    public HttpServerRequest bodyHandler(final Handler<Buffer> bodyHandler) {
        final Buffer body = new Buffer();
        this.dataHandler((Handler)new Handler<Buffer>(){

            @Override
            public void handle(Buffer buff) {
                body.appendBuffer(buff);
            }
        });
        this.endHandler((Handler)new VoidHandler(){

            @Override
            public void handle() {
                bodyHandler.handle(body);
            }
        });
        return this;
    }

    @Override
    public NetSocket netSocket() {
        if (this.netSocket == null) {
            this.netSocket = this.conn.createNetSocket();
        }
        return this.netSocket;
    }

    @Override
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        this.uploadHandler = handler;
        return this;
    }

    @Override
    public MultiMap formAttributes() {
        if (this.decoder == null) {
            throw new IllegalStateException("Call expectMultiPart(true) before request body is received to receive form attributes");
        }
        return this.attributes();
    }

    @Override
    public HttpServerRequest expectMultiPart(boolean expect) {
        if (expect) {
            String contentType = this.request.headers().get("Content-Type");
            if (contentType != null) {
                HttpMethod method = this.request.getMethod();
                String lowerCaseContentType = contentType.toLowerCase();
                this.isURLEncoded = lowerCaseContentType.startsWith("application/x-www-form-urlencoded");
                if ((lowerCaseContentType.startsWith("multipart/form-data") || this.isURLEncoded) && (method.equals((Object)HttpMethod.POST) || method.equals((Object)HttpMethod.PUT) || method.equals((Object)HttpMethod.PATCH))) {
                    this.decoder = new HttpPostRequestDecoder((HttpDataFactory)new DataFactory(), this.request);
                }
            }
        } else {
            this.decoder = null;
        }
        return this;
    }

    void handleData(Buffer data) {
        if (this.decoder != null) {
            try {
                this.decoder.offer((HttpContent)new DefaultHttpContent(data.getByteBuf().duplicate()));
            }
            catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                this.handleException(e);
            }
        }
        if (this.dataHandler != null) {
            this.dataHandler.handle(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEnd() {
        if (this.decoder != null) {
            try {
                this.decoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
                while (this.decoder.hasNext()) {
                    InterfaceHttpData data = this.decoder.next();
                    if (!(data instanceof Attribute)) continue;
                    Attribute attr = (Attribute)data;
                    try {
                        if (this.isURLEncoded) {
                            this.attributes().add(DefaultHttpServerRequest.urlDecode(attr.getName()), DefaultHttpServerRequest.urlDecode(attr.getValue()));
                            continue;
                        }
                        this.attributes().add(attr.getName(), attr.getValue());
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                }
            }
            catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                this.handleException(e);
            }
            catch (HttpPostRequestDecoder.EndOfDataDecoderException endOfDataDecoderException) {
            }
            finally {
                this.decoder.destroy();
            }
        }
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t);
        }
    }

    private MultiMap attributes() {
        if (this.attributes == null) {
            this.attributes = new CaseInsensitiveMultiMap();
        }
        return this.attributes;
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.conn.localAddress();
    }

    private static String urlDecode(String str) {
        return QueryStringDecoder.decodeComponent((String)str, (Charset)CharsetUtil.UTF_8);
    }

    private class DataFactory
    extends DefaultHttpDataFactory {
        DataFactory() {
            super(false);
        }

        public FileUpload createFileUpload(HttpRequest httpRequest, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
            DefaultHttpServerFileUpload upload = new DefaultHttpServerFileUpload(DefaultHttpServerRequest.this.conn.vertx(), DefaultHttpServerRequest.this, name, filename, contentType, contentTransferEncoding, charset, size);
            NettyFileUpload nettyUpload = new NettyFileUpload(upload, name, filename, contentType, contentTransferEncoding, charset);
            if (DefaultHttpServerRequest.this.uploadHandler != null) {
                DefaultHttpServerRequest.this.uploadHandler.handle(upload);
            }
            return nettyUpload;
        }
    }

    private static final class NettyFileUpload
    implements FileUpload {
        private final DefaultHttpServerFileUpload upload;
        private String name;
        private String filename;
        private String contentType;
        private String contentTransferEncoding;
        private Charset charset;
        private boolean completed;

        private NettyFileUpload(DefaultHttpServerFileUpload upload, String name, String filename, String contentType, String contentTransferEncoding, Charset charset) {
            this.upload = upload;
            this.name = name;
            this.filename = filename;
            this.contentType = contentType;
            this.contentTransferEncoding = contentTransferEncoding;
            this.charset = charset;
        }

        public void setContent(ByteBuf channelBuffer) throws IOException {
            this.completed = true;
            this.upload.receiveData(new Buffer(channelBuffer));
            this.upload.complete();
        }

        public void addContent(ByteBuf channelBuffer, boolean last) throws IOException {
            this.upload.receiveData(new Buffer(channelBuffer));
            if (last) {
                this.completed = true;
                this.upload.complete();
            }
        }

        public void setContent(File file) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void setContent(InputStream inputStream) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public long length() {
            throw new UnsupportedOperationException();
        }

        public void delete() {
            throw new UnsupportedOperationException();
        }

        public byte[] get() throws IOException {
            throw new UnsupportedOperationException();
        }

        public ByteBuf getChunk(int i) throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getString() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getString(Charset charset) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public boolean renameTo(File file) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean isInMemory() {
            return false;
        }

        public File getFile() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return this.name;
        }

        public InterfaceHttpData.HttpDataType getHttpDataType() {
            throw new UnsupportedOperationException();
        }

        public int compareTo(InterfaceHttpData o) {
            return 0;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentTransferEncoding(String contentTransferEncoding) {
            this.contentTransferEncoding = contentTransferEncoding;
        }

        public String getContentTransferEncoding() {
            return this.contentTransferEncoding;
        }

        public ByteBuf getByteBuf() throws IOException {
            throw new UnsupportedOperationException();
        }

        public FileUpload copy() {
            throw new UnsupportedOperationException();
        }

        public FileUpload duplicate() {
            throw new UnsupportedOperationException();
        }

        public FileUpload retain() {
            return this;
        }

        public FileUpload retain(int increment) {
            return this;
        }

        public ByteBuf content() {
            throw new UnsupportedOperationException();
        }

        public int refCnt() {
            return 1;
        }

        public boolean release() {
            return false;
        }

        public boolean release(int decrement) {
            return false;
        }
    }
}

