/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.impl.BaseMessage;
import org.vertx.java.core.eventbus.impl.BooleanMessage;
import org.vertx.java.core.eventbus.impl.BufferMessage;
import org.vertx.java.core.eventbus.impl.ByteArrayMessage;
import org.vertx.java.core.eventbus.impl.ByteMessage;
import org.vertx.java.core.eventbus.impl.CharacterMessage;
import org.vertx.java.core.eventbus.impl.DoubleMessage;
import org.vertx.java.core.eventbus.impl.FloatMessage;
import org.vertx.java.core.eventbus.impl.IntMessage;
import org.vertx.java.core.eventbus.impl.JsonArrayMessage;
import org.vertx.java.core.eventbus.impl.JsonObjectMessage;
import org.vertx.java.core.eventbus.impl.LongMessage;
import org.vertx.java.core.eventbus.impl.PingMessage;
import org.vertx.java.core.eventbus.impl.ReplyFailureMessage;
import org.vertx.java.core.eventbus.impl.ShortMessage;
import org.vertx.java.core.eventbus.impl.StringMessage;

public class MessageFactory {
    static final byte TYPE_PING = 0;
    static final byte TYPE_BUFFER = 1;
    static final byte TYPE_BOOLEAN = 2;
    static final byte TYPE_BYTEARRAY = 3;
    static final byte TYPE_BYTE = 4;
    static final byte TYPE_CHARACTER = 5;
    static final byte TYPE_DOUBLE = 6;
    static final byte TYPE_FLOAT = 7;
    static final byte TYPE_INT = 8;
    static final byte TYPE_LONG = 9;
    static final byte TYPE_SHORT = 10;
    static final byte TYPE_STRING = 11;
    static final byte TYPE_JSON_OBJECT = 12;
    static final byte TYPE_JSON_ARRAY = 13;
    static final byte TYPE_REPLY_FAILURE = 100;

    static BaseMessage read(Buffer buff) {
        byte type = buff.getByte(0);
        switch (type) {
            case 0: {
                return new PingMessage(buff);
            }
            case 1: {
                return new BufferMessage(buff);
            }
            case 2: {
                return new BooleanMessage(buff);
            }
            case 3: {
                return new ByteArrayMessage(buff);
            }
            case 4: {
                return new ByteMessage(buff);
            }
            case 5: {
                return new CharacterMessage(buff);
            }
            case 6: {
                return new DoubleMessage(buff);
            }
            case 7: {
                return new FloatMessage(buff);
            }
            case 8: {
                return new IntMessage(buff);
            }
            case 9: {
                return new LongMessage(buff);
            }
            case 10: {
                return new ShortMessage(buff);
            }
            case 11: {
                return new StringMessage(buff);
            }
            case 12: {
                return new JsonObjectMessage(buff);
            }
            case 13: {
                return new JsonArrayMessage(buff);
            }
            case 100: {
                return new ReplyFailureMessage(buff);
            }
        }
        throw new IllegalStateException("Invalid type " + type);
    }
}

