/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.BaseMessage;

class BooleanMessage
extends BaseMessage<Boolean> {
    BooleanMessage(boolean send, String address, Boolean body) {
        super(send, address, body);
    }

    public BooleanMessage(Buffer readBuff) {
        super(readBuff);
    }

    @Override
    protected void readBody(int pos, Buffer readBuff) {
        boolean isNull;
        boolean bl = isNull = readBuff.getByte(pos) == 0;
        if (!isNull) {
            this.body = readBuff.getByte(pos + 1) == 1;
        }
    }

    @Override
    protected void writeBody(Buffer buff) {
        if (this.body == null) {
            buff.appendByte((byte)0);
        } else {
            buff.appendByte((byte)1);
            buff.appendByte((Boolean)this.body != false ? (byte)1 : 0);
        }
    }

    @Override
    protected int getBodyLength() {
        return 1 + (this.body == null ? 0 : 1);
    }

    @Override
    protected Message<Boolean> copy() {
        return this;
    }

    @Override
    protected byte type() {
        return 2;
    }
}

