/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.core;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.woelker.jimix.core.HttpRequest;
import org.woelker.jimix.core.JimixIOUtils;
import org.woelker.jimix.core.RequestHandler;

public class AssetRequestHandler
implements RequestHandler {
    Map<String, String> mimeTypeMap = new HashMap<String, String>();

    public AssetRequestHandler() {
        this.mimeTypeMap.put("html", "text/html");
        this.mimeTypeMap.put("css", "text/css");
        this.mimeTypeMap.put("js", "application/javascript");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpRequest httpRequest) throws Exception {
        InputStream inputStream;
        String path = httpRequest.getPathInfo();
        if ("/".equals(path)) {
            path = "/index.html";
        }
        if ((inputStream = AssetRequestHandler.class.getResourceAsStream("/org/woelker/jimix/ui/assets" + path)) == null) {
            httpRequest.sendError(404);
            return;
        }
        try {
            int lastDotIndex = path.lastIndexOf(".");
            String extension = path.substring(lastDotIndex + 1);
            String mimeType = this.mimeTypeMap.get(extension);
            if (mimeType == null) {
                mimeType = "text/plain";
            }
            httpRequest.setContentType(mimeType);
            JimixIOUtils.copy(inputStream, httpRequest.getOutputStream());
        }
        finally {
            inputStream.close();
        }
    }
}

