/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.core;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import org.woelker.jimix.core.HttpRequest;
import org.woelker.jimix.core.JsonWriter;
import org.woelker.jimix.core.RequestHandler;

public class MbeanRequestHandler
implements RequestHandler {
    MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    @Override
    public void handle(HttpRequest httpRequest) throws Exception {
        String objectName = (String)httpRequest.getAttribute("param-0");
        Set<ObjectInstance> instances = this.mbeanServer.queryMBeans(new ObjectName(objectName), null);
        if (instances.isEmpty()) {
            httpRequest.sendError(404);
            return;
        }
        HashMap result = new HashMap();
        ObjectInstance instance = instances.iterator().next();
        MBeanInfo mBeanInfo = this.mbeanServer.getMBeanInfo(instance.getObjectName());
        ArrayList attributes = new ArrayList();
        result.put("attributes", attributes);
        for (MBeanAttributeInfo attributeInfo : mBeanInfo.getAttributes()) {
            HashMap<String, Object> attribute = new HashMap<String, Object>();
            attribute.put("name", attributeInfo.getName());
            attribute.put("type", attributeInfo.getType());
            attribute.put("description", attributeInfo.getDescription());
            attribute.put("writable", attributeInfo.isWritable());
            try {
                attribute.put("value", this.mbeanServer.getAttribute(instance.getObjectName(), attributeInfo.getName()));
            }
            catch (RuntimeMBeanException ignored) {
                attribute.put("value", null);
            }
            attributes.add(attribute);
        }
        ArrayList operations = new ArrayList();
        result.put("operations", operations);
        for (MBeanOperationInfo operationInfo : mBeanInfo.getOperations()) {
            HashMap<String, Object> operation = new HashMap<String, Object>();
            operation.put("name", operationInfo.getName());
            operation.put("returnType", operationInfo.getReturnType());
            operation.put("description", operationInfo.getDescription());
            ArrayList signature = new ArrayList();
            operation.put("signature", signature);
            for (MBeanParameterInfo parameterInfo : operationInfo.getSignature()) {
                HashMap<String, String> parameter = new HashMap<String, String>();
                parameter.put("name", parameterInfo.getName());
                parameter.put("type", parameterInfo.getType());
                parameter.put("description", parameterInfo.getDescription());
                signature.add(parameter);
            }
            operations.add(operation);
        }
        new JsonWriter(httpRequest.getOutputStream()).serialize(result);
    }
}

