/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl;

import org.vertx.java.core.Vertx;
import org.vertx.java.platform.Container;
import org.vertx.java.platform.VerticleFactory;
import org.vertx.java.platform.impl.ModuleClassLoader;
import org.vertx.java.platform.impl.PlatformManagerInternal;

class ModuleReference {
    final PlatformManagerInternal mgr;
    final String moduleKey;
    final ModuleClassLoader mcl;
    int refCount = 0;
    private VerticleFactory factory;
    final boolean resident;

    ModuleReference(PlatformManagerInternal mgr, String moduleKey, ModuleClassLoader mcl, boolean resident) {
        this.mgr = mgr;
        this.moduleKey = moduleKey;
        this.mcl = mcl;
        this.resident = resident;
    }

    synchronized void incRef() {
        ++this.refCount;
    }

    synchronized void decRef() {
        --this.refCount;
        if (!this.resident && this.refCount == 0) {
            this.mgr.removeModule(this.moduleKey);
            this.mcl.close();
            if (this.factory != null) {
                this.factory.close();
            }
        }
    }

    public synchronized VerticleFactory getVerticleFactory(String factoryName, Vertx vertx, Container container) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.factory == null) {
            Class<?> clazz = this.mcl.loadClass(factoryName);
            this.factory = (VerticleFactory)clazz.newInstance();
            this.factory.init(vertx, container, this.mcl);
        }
        return this.factory;
    }
}

