/*
 * Decompiled with CFR 0.152.
 */
package org.woelker.jimix.vertx;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;
import org.woelker.jimix.core.HttpRequest;

class VertxHttpRequestWrapper
implements HttpRequest {
    private final HttpServerRequest request;
    private final HttpServerResponse response;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public VertxHttpRequestWrapper(HttpServerRequest request) {
        this.request = request;
        this.response = request.response();
    }

    public String getMethod() {
        return this.request.method();
    }

    public String getPathInfo() {
        try {
            return this.urlDecode(this.request.params().get("param0"));
        }
        catch (URISyntaxException e) {
            return this.request.params().get("param0");
        }
    }

    public String getQueryString() {
        return this.request.query();
    }

    private String urlDecode(String url) throws URISyntaxException {
        return new URI(url).getPath();
    }

    public String getRequestURI() {
        return this.request.uri();
    }

    public void setContentType(String contentType) {
        this.request.response().putHeader("Content-Type", contentType);
    }

    public OutputStream getOutputStream() throws IOException {
        this.response.setChunked(true);
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                Buffer buffer = new Buffer(1);
                buffer.appendByte((byte)b);
                VertxHttpRequestWrapper.this.response.write(buffer);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                Buffer buffer = new Buffer(len);
                buffer.appendBytes(b, off, len);
                VertxHttpRequestWrapper.this.response.write(buffer);
            }
        };
    }

    public void sendError(int errorStatus) throws IOException {
        this.response.setStatusCode(errorStatus);
    }

    public void setStatus(int status) throws IOException {
        this.response.setStatusCode(status);
    }

    public void sendRedirect(String url) throws IOException {
        this.response.putHeader("Location", url);
        this.response.setStatusCode(301);
    }

    public void setAttribute(String key, Object attribute) {
        this.attributes.put(key, attribute);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setHeader(String header, String value) {
        this.response.putHeader(header, value);
    }
}

