/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.confluence;

import java.util.HashMap;
import java.util.Map;
import org.wooddog.mavenplugins.confluence.ConfluenceException;
import org.wooddog.mavenplugins.confluence.Session;
import org.wooddog.mavenplugins.confluence.domain.BlogSummary;
import org.wooddog.mavenplugins.confluence.domain.PageSummary;

public class Cache {
    public static final Cache INSTANCE = new Cache();
    private Map<String, Map<String, PageSummary>> pageSpaceIdMap = new HashMap<String, Map<String, PageSummary>>();
    private Map<String, Map<String, BlogSummary>> blogSpaceIdMap = new HashMap<String, Map<String, BlogSummary>>();

    private Cache() {
    }

    public static Cache getInstance() {
        return INSTANCE;
    }

    public PageSummary getPageSummary(Session session, String space, String title) throws ConfluenceException {
        Map<String, PageSummary> idMap = this.pageSpaceIdMap.get(space);
        if (idMap == null) {
            Object[] pageSummaries;
            idMap = new HashMap<String, PageSummary>();
            this.pageSpaceIdMap.put(space, idMap);
            for (Object pageSummary : pageSummaries = (Object[])session.send("getPages", space)) {
                idMap.put(((Map)pageSummary).get("title").toString(), new PageSummary((Map)pageSummary));
            }
        }
        return idMap.get(title);
    }

    public BlogSummary getBlogSummary(Session session, String space, String title) throws ConfluenceException {
        Map<String, BlogSummary> idMap = this.blogSpaceIdMap.get(space);
        if (idMap == null) {
            Object[] blogSummaries;
            idMap = new HashMap<String, BlogSummary>();
            this.blogSpaceIdMap.put(space, idMap);
            for (Object o : blogSummaries = (Object[])session.send("getBlogEntries", space)) {
                idMap.put(((Map)o).get("title").toString(), new BlogSummary((Map)o));
            }
        }
        return idMap.get(title);
    }
}

