/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.confluence;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class Context {
    private static final Context INSTANCE = new Context();
    private static Log logger;
    private Map<String, Object> values = new HashMap<String, Object>();

    private Context() {
        logger = new SystemStreamLog();
    }

    public static String getProperty(String property) {
        return INSTANCE.getValue(property);
    }

    public static void add(String key, Object value) {
        Context.INSTANCE.values.put(key, value);
    }

    public static void addAll(Map map) {
        for (Object key : map.keySet()) {
            Context.add(key.toString(), map.get(key));
        }
    }

    public static void setLogger(Log log) {
        logger = log;
    }

    public static Log getLogger() {
        return logger;
    }

    private String getValue(String key) {
        String rootKey;
        Object value = null;
        if (this.values.containsKey(key)) {
            value = this.values.get(key);
        } else if (key.indexOf(".") != -1 && this.values.containsKey(rootKey = key.substring(0, key.indexOf(".")))) {
            value = this.resolve(key.substring(rootKey.length() + 1), this.values.get(rootKey));
        }
        if (value != null) {
            value = this.evaluate(this.toString(value));
        }
        return (String)value;
    }

    private Object resolve(String property, Object object) {
        if (object instanceof Map) {
            return ((Map)object).get(property);
        }
        if (property.indexOf(".") == -1) {
            return this.getPropertyValue(property, object);
        }
        String rootProperty = property.substring(0, property.indexOf("."));
        String subProperty = property.substring(rootProperty.length() + 1);
        return this.resolve(subProperty, this.getPropertyValue(rootProperty, object));
    }

    private String evaluate(String value) {
        Pattern pattern = Pattern.compile("(\\$\\{([\\w\\.]+)\\})");
        Matcher matcher = pattern.matcher(value);
        StringBuffer result = new StringBuffer();
        int pos = 0;
        while (matcher.find()) {
            result.append(value.substring(pos, matcher.start(1)));
            result.append(Context.getProperty(matcher.group(2)));
            pos = matcher.end(1);
        }
        result.append(value.substring(pos));
        return result.toString();
    }

    private String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private Object getPropertyValue(String property, Object object) {
        Object value;
        String methodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
        try {
            Method method = object.getClass().getMethod(methodName, new Class[0]);
            value = method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException x) {
            throw new RuntimeException(x);
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
        catch (InvocationTargetException x) {
            throw new RuntimeException(x);
        }
        return value;
    }
}

