/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.confluence;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DocumentResult;
import org.wooddog.mavenplugins.confluence.ConfluenceException;
import org.wooddog.mavenplugins.confluence.Session;
import org.wooddog.mavenplugins.confluence.operation.AttachmentOperation;
import org.wooddog.mavenplugins.confluence.operation.BlogOperation;
import org.wooddog.mavenplugins.confluence.operation.Operation;
import org.wooddog.mavenplugins.confluence.operation.PageOperation;

public class Operator {
    private Map<String, Operation> operationMap;
    private Session session;

    public Operator(URL url, String username, String password) throws ConfluenceException {
        this.session = Session.getSession(url, username, password);
        this.operationMap = new HashMap<String, Operation>();
        this.operationMap.put("blog", new BlogOperation());
        this.operationMap.put("page", new PageOperation());
        this.operationMap.put("attachment", new AttachmentOperation());
    }

    public void run(File file) throws ConfluenceException {
        File[] files = file.isDirectory() ? file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".xml");
            }
        }) : new File[]{file};
        this.run(files);
    }

    public void run(File[] files) throws ConfluenceException {
        for (File file : files) {
            Document document = this.transform(file);
            this.run(document);
        }
    }

    public Document transform(File file) throws ConfluenceException {
        DocumentResult result;
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Source stylesheet = factory.getAssociatedStylesheet(new StreamSource(file), null, null, null);
            CatalogResolver resolver = new CatalogResolver();
            Transformer transformer = stylesheet == null ? factory.newTransformer() : factory.newTransformer(stylesheet);
            transformer.setURIResolver((URIResolver)resolver);
            result = new DocumentResult();
            transformer.transform(new StreamSource(file), (Result)result);
        }
        catch (TransformerConfigurationException x) {
            throw new ConfluenceException("error initializing xml transformer", x);
        }
        catch (TransformerException x) {
            throw new ConfluenceException("error transforming document " + file.getAbsolutePath(), x);
        }
        return result.getDocument();
    }

    private void run(Document document) throws ConfluenceException {
        List operations = document.getRootElement().elements();
        for (Element operation : operations) {
            this.operationMap.get(operation.getName()).execute(this.session, operation);
        }
    }
}

