/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.confluence;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.wooddog.mavenplugins.confluence.ConfluenceException;

public class Session {
    private String token;
    private XmlRpcClient client;

    private Session(XmlRpcClient client, String username, String password) throws ConfluenceException {
        this.client = client;
        try {
            this.token = (String)client.execute("confluence1.login", new Object[]{username, password});
        }
        catch (XmlRpcException x) {
            throw new ConfluenceException("authorization error", x);
        }
    }

    public static Session getSession(URL url, String username, String password) throws ConfluenceException {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        XmlRpcClient client = new XmlRpcClient();
        try {
            config.setServerURL(new URL(url, "rpc/xmlrpc"));
        }
        catch (MalformedURLException x) {
            throw new ConfluenceException("unable to construct confluence remote api url", x);
        }
        client.setConfig((XmlRpcClientConfig)config);
        return new Session(client, username, password);
    }

    public Object send(String method, Map values) throws ConfluenceException {
        Object result;
        try {
            result = this.client.execute("confluence1." + method, new Object[]{this.token, values});
        }
        catch (XmlRpcException x) {
            throw new ConfluenceException("error executing " + method + " with values " + values);
        }
        return result;
    }

    public Object send(String method, Object ... objects) throws ConfluenceException {
        Object result;
        ArrayList<Object> params = new ArrayList<Object>(Arrays.asList(objects));
        params.add(0, this.token);
        try {
            result = this.client.execute("confluence1." + method, params);
        }
        catch (XmlRpcException x) {
            throw new ConfluenceException("error executing " + method + " with values " + params);
        }
        return result;
    }
}

