/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.confluence.operation;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.plugin.logging.Log;
import org.dom4j.Element;
import org.wooddog.mavenplugins.confluence.Cache;
import org.wooddog.mavenplugins.confluence.ConfluenceException;
import org.wooddog.mavenplugins.confluence.Context;
import org.wooddog.mavenplugins.confluence.Session;
import org.wooddog.mavenplugins.confluence.domain.Attachment;
import org.wooddog.mavenplugins.confluence.domain.PageSummary;
import org.wooddog.mavenplugins.confluence.operation.Operation;

public class AttachmentOperation
implements Operation {
    private static final Log LOGGER = Context.getLogger();

    @Override
    public void execute(Session session, Element element) throws ConfluenceException {
        String space = element.elementText("space");
        String title = element.elementText("pageTitle");
        byte[] fileData = this.readFile(new File(element.elementText("file")));
        PageSummary pageSummary = Cache.getInstance().getPageSummary(session, space, title);
        if (pageSummary == null) {
            throw new ConfluenceException("attachment error, no page found with title " + title + " in space " + space);
        }
        String pageId = pageSummary.getId();
        Attachment attachment = new Attachment();
        attachment.setComment(element.elementText("comment"));
        attachment.setContentType(element.elementText("contentType"));
        attachment.setFileName(element.elementText("fileName"));
        if (this.hasChanges(session, pageId, attachment.getFileName(), fileData)) {
            LOGGER.info((CharSequence)("uploading attachment \"" + space + "/" + title + "/" + attachment.getFileName() + "\""));
            session.send("addAttachment", pageId, attachment.getValues(), fileData);
        } else {
            LOGGER.info((CharSequence)("no changes found for attachment \"" + space + "/" + title + "/" + attachment.getFileName() + "\""));
        }
    }

    private boolean hasChanges(Session session, String pageId, String fileName, byte[] source) throws ConfluenceException {
        try {
            session.send("getAttachment", pageId, fileName, "0");
        }
        catch (ConfluenceException x) {
            return true;
        }
        byte[] target = (byte[])session.send("getAttachmentData", pageId, fileName, "0");
        if (source.length != target.length) {
            return true;
        }
        for (int i = 0; i < source.length; ++i) {
            if (source[i] == target[i]) continue;
            return true;
        }
        return false;
    }

    private byte[] readFile(File file) throws ConfluenceException {
        ByteArrayOutputStream fileData = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        BufferedInputStream in = null;
        try {
            int length;
            in = new BufferedInputStream(new FileInputStream(file));
            while ((length = ((InputStream)in).read(buffer)) != -1) {
                fileData.write(buffer, 0, length);
            }
            this.close(in);
            this.close(fileData);
        }
        catch (IOException x) {
            try {
                throw new ConfluenceException("failed reading file " + file.getAbsolutePath(), x);
            }
            catch (Throwable throwable) {
                this.close(in);
                this.close(fileData);
                throw throwable;
            }
        }
        return fileData.toByteArray();
    }

    private void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }

    private void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }
}

