/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.confluence.operation;

import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.dom4j.Element;
import org.wooddog.mavenplugins.confluence.Cache;
import org.wooddog.mavenplugins.confluence.ConfluenceException;
import org.wooddog.mavenplugins.confluence.Context;
import org.wooddog.mavenplugins.confluence.Session;
import org.wooddog.mavenplugins.confluence.domain.Blog;
import org.wooddog.mavenplugins.confluence.domain.BlogSummary;
import org.wooddog.mavenplugins.confluence.operation.Operation;

public class BlogOperation
implements Operation {
    private static final Log LOGGER = Context.getLogger();

    @Override
    public void execute(Session session, Element element) throws ConfluenceException {
        Blog blog = new Blog();
        blog.setSpace(element.element("space").getText());
        blog.setTitle(element.element("title").getText());
        blog.setContent(element.element("content").getText());
        BlogSummary blogSummary = Cache.getInstance().getBlogSummary(session, blog.getSpace(), blog.getTitle());
        if (blogSummary != null) {
            blog.setId(blogSummary.getId());
        }
        if ("".equals(blog.getSpace().trim())) {
            throw new ConfluenceException("space is not allowed to be empty when updating blogs");
        }
        if ("".equals(blog.getTitle().trim())) {
            throw new ConfluenceException("title is not allowed to be empty when updating blogs");
        }
        if (this.hasChanges(session, blog)) {
            LOGGER.info((CharSequence)("publishing blog \"" + blog.getSpace() + "/" + blog.getTitle() + "\""));
            session.send("storeBlogEntry", blog.getValues());
        } else {
            LOGGER.info((CharSequence)("no changes found for blog \"" + blog.getSpace() + "/" + blog.getTitle() + "\""));
        }
    }

    private boolean hasChanges(Session session, Blog blog) throws ConfluenceException {
        Blog currentBlog = new Blog((Map)session.send("getBlogEntry", blog.getId()));
        return !blog.getContent().equals(currentBlog.getContent());
    }
}

