/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.confluence.operation;

import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.dom4j.Element;
import org.wooddog.mavenplugins.confluence.Cache;
import org.wooddog.mavenplugins.confluence.ConfluenceException;
import org.wooddog.mavenplugins.confluence.Context;
import org.wooddog.mavenplugins.confluence.Session;
import org.wooddog.mavenplugins.confluence.domain.Page;
import org.wooddog.mavenplugins.confluence.domain.PageSummary;
import org.wooddog.mavenplugins.confluence.operation.Operation;

public class PageOperation
implements Operation {
    private static final Log LOGGER = Context.getLogger();

    private int getVersion(Session session, String pageId) throws ConfluenceException {
        Map page = (Map)session.send("getPage", pageId);
        return Integer.parseInt(page.get("version").toString());
    }

    @Override
    public void execute(Session session, Element element) throws ConfluenceException {
        Page page = new Page();
        page.setSpace(element.element("space").getText());
        page.setTitle(element.element("title").getText());
        page.setContent(element.element("content").getText());
        PageSummary pageSummary = Cache.getInstance().getPageSummary(session, page.getSpace(), page.getTitle());
        if (pageSummary != null) {
            page.setId(pageSummary.getId());
            page.setVersion(this.getVersion(session, page.getId()));
        }
        if ("".equals(page.getSpace().trim())) {
            throw new ConfluenceException("space is not allowed to be empty when updating pages");
        }
        if ("".equals(page.getTitle().trim())) {
            throw new ConfluenceException("title is not allowed to be empty when updating pages");
        }
        if (this.hasChanges(session, page)) {
            LOGGER.info((CharSequence)("publishing page \"" + page.getSpace() + "/" + page.getTitle() + "\""));
            session.send("storePage", page.getValues());
        } else {
            LOGGER.info((CharSequence)("no changes found for \"" + page.getSpace() + "/" + page.getTitle() + "\""));
        }
    }

    private boolean hasChanges(Session session, Page page) throws ConfluenceException {
        Page currentPage = new Page((Map)session.send("getPage", page.getId()));
        return !page.getContent().equals(currentPage.getContent());
    }
}

