/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import org.wooddog.mavenplugins.version.Config;
import org.wooddog.mavenplugins.version.InputStreamGobbler;
import org.wooddog.mavenplugins.version.Message;
import org.wooddog.mavenplugins.version.exception.CommandLineInterfaceException;

public class CommandLineInterface {
    private static final String CONFIGFILE = "org/wooddog/mavenplugins/version/cli/config.properties";
    private static final String OS = System.getProperty("os.name");
    private String[] shell;
    private static final CommandLineInterface CLI = CommandLineInterface.create();

    protected CommandLineInterface() {
        Properties properties = CommandLineInterface.getConfig();
        String key = CommandLineInterface.getConfigKey(properties);
        String shell = (String)properties.get(key + ".shell");
        this.shell = shell == null ? new String[0] : shell.trim().split(" ");
        this.write(new Message(0, "\n--- log started ---\n", ""), "");
    }

    public static CommandLineInterface getCommandLineInterface() {
        return CLI;
    }

    protected String[] buildArguments(String ... args) {
        String[] arguments = new String[args.length + this.shell.length];
        System.arraycopy(this.shell, 0, arguments, 0, this.shell.length);
        System.arraycopy(args, 0, arguments, this.shell.length, args.length);
        return arguments;
    }

    public Message execute(String ... args) throws CommandLineInterfaceException {
        int status;
        Process process;
        String[] arguments = this.buildArguments(args);
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(arguments);
        }
        catch (IOException x) {
            throw new CommandLineInterfaceException("unable to execute " + this.asString(arguments));
        }
        InputStreamGobbler stdin = new InputStreamGobbler(process.getInputStream());
        InputStreamGobbler err = new InputStreamGobbler(process.getErrorStream());
        stdin.start();
        err.start();
        try {
            status = process.waitFor();
            stdin.kill();
            err.kill();
        }
        catch (InterruptedException x) {
            throw new CommandLineInterfaceException("command process killed", x);
        }
        Message message = new Message(status, stdin.getResult(), err.getResult());
        if (Config.getInstance().get("version.cli.debug") != null) {
            this.write(message, args);
        }
        return message;
    }

    public String asString(String[] values) {
        String str = "";
        for (String value : values) {
            str = str + " \"" + value + "\"";
        }
        return str.substring(1);
    }

    private static CommandLineInterface create() {
        Properties properties = CommandLineInterface.getConfig();
        String key = CommandLineInterface.getConfigKey(properties);
        if (key == null) {
            return new CommandLineInterface();
        }
        return CommandLineInterface.createClass((String)properties.get(key + ".cli"));
    }

    private static String getConfigKey(Properties properties) {
        String[] keys;
        properties = CommandLineInterface.getConfig();
        for (String key : keys = ((String)properties.get("os")).split(",")) {
            String osName = (String)properties.get(key + ".name");
            if (osName == null || !osName.trim().equals(OS)) continue;
            return key;
        }
        return "default";
    }

    private static Properties getConfig() throws CommandLineInterfaceException {
        Properties properties = new Properties();
        try {
            properties.load(CommandLineInterface.class.getClassLoader().getResourceAsStream(CONFIGFILE));
        }
        catch (IOException x) {
            throw new CommandLineInterfaceException("unable to load org/wooddog/mavenplugins/version/cli/config.properties", x);
        }
        catch (NullPointerException x) {
            throw new CommandLineInterfaceException("unable to find org/wooddog/mavenplugins/version/cli/config.properties", x);
        }
        return properties;
    }

    private static CommandLineInterface createClass(String className) {
        CommandLineInterface commandLineInterface;
        try {
            commandLineInterface = (CommandLineInterface)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new CommandLineInterfaceException("unable to find class " + className + " specified for OS " + OS + " in " + CONFIGFILE + " in classpath", x);
        }
        catch (IllegalAccessException x) {
            throw new CommandLineInterfaceException("no constructor found in class " + className + " specified for OS " + OS + " in " + CONFIGFILE, x);
        }
        catch (InstantiationException x) {
            throw new CommandLineInterfaceException("unable instantiate class " + className + " specified for OS " + OS + " in " + CONFIGFILE, x);
        }
        catch (ClassCastException x) {
            throw new CommandLineInterfaceException("class " + className + " specified for os " + OS + " in " + CONFIGFILE + " is not of type " + CommandLineInterface.class.getName(), x);
        }
        return commandLineInterface;
    }

    public void deleteLog() {
        new File("version-cli.log").delete();
    }

    private void write(Message message, String ... args) throws CommandLineInterfaceException {
        File file = new File("version-cli.log");
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file, true));
            writer.write(this.asString(args) + System.getProperty("line.separator"));
            writer.write(message.getMessage());
            this.close(writer);
        }
        catch (IOException x) {
            try {
                throw new CommandLineInterfaceException("unable to write debug log " + file.getAbsolutePath(), x);
            }
            catch (Throwable throwable) {
                this.close(writer);
                throw throwable;
            }
        }
    }

    private void close(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }
}

